<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT	
 * date created			: 10-09-07
 * date modified		: $Id: Category.class.php 176 2007-10-25 09:19:41Z ivo $
 */

class Category {
	
	private $categories_table = 'categories';
	private $category_texts_table = 'category_texts';
	private $category_files_table = '';#'category_files';

	private $categoryId;
	private $parentId;
	private $prio;
	private $hide;
	private $public;
	private $template; 
	private $styleclass; 
	private $hookName; 
	private $adminmodule; 
	private $module;
	private $languages;
	private $level;
	private $parentLabel;
	public  $isNew;
	private $languageObject;
	private $files;
	private $clearCache = False;
	public $errorMsg = '';

	public function __construct($categoryId=False, $basic=False) {
		global $mydb, $catconf;

		if($catconf){
			if(isset($catconf['categories_table'])){
				$this->categories_table = $catconf['categories_table'];
			}

			if(isset($catconf['categories_texts_table'])){
				$this->categories_texts_table = $catconf['categories_table_table'];
			}

			if(isset($catconf['category_files_table'])){
				$this->category_files_table = $catconf['category_files_table'];
			}

			if(isset($catconf['toplevel'])){
				$this->parentId = $catconf['toplevel'];
			}

		}

		$this->isNew = ($categoryId === False ? True : False);
		$this->categoryId = $categoryId;
		if($categoryId == False) {
			$this->isNew = True;
		} else {
			$this->getData();
		}

		#if basic -> only cat data no files or languages
		if(!$basic) {
			if(isset($_SESSION['language'])){
				$this->setLanguage($_SESSION['language']);
			} else {
				$this->setLanguage(DEFAULT_LANGUAGE);
			}
			$this->files = array();
			if(!$this->isNew){
				$this->getFilesFromDatabase();
			}
		}
	}

	public function clearCache() {
		$this->clearCache = True;
		if(!$this->isNew) {
			$this->getData();
			$this->getFilesFromDatabase();
		}
	}
	private function getData() {
		global $mydb;
# static is bull**** want we komen hier vaak toch maar 1 keer in deze instantie 
#		static $catData = array();
#		if(isset($catData[$this->categoryId]) and !$this->clearCache) {
#			$data = $catData[$this->categoryId];
#		} else {
			$result = $mydb->getRecords($this->categories_table, 'category_id', $this->categoryId);
			$data = mysql_fetch_object($result);
			$catData[$this->categoryId] = $data;
#		}
		if(is_object($data)) {
			$this->parentId = $data->parent_id;
			$this->prio = $data->prio;
			$this->hide = ($data->hide == '1'? True : False);
			if(isset($data->public)){
				$this->public = ($data->public == '1'? True : False);
			} else {
				trigger_error("Property 'public' is not defined in database.");
			}
			$this->template = $data->template;
			if(isset($data->styleclass)) {
				$this->styleclass = $data->styleclass;
			}
			if(isset($data->hookName)) {
				$this->hookName = $data->hookName;
			}
			$this->adminmodule = $data->adminmodule;
			$this->module = $data->module;
		}
	}

	public function getAllSettings(){
		global $mydb;
		$settings = $this->getDefaultSettings();
		$records = $mydb->getRecordsArray("um_category2settings", "categoryId", $this->categoryId);
		foreach ($records as $row){
			foreach($settings as $setting){
				if($setting->getCategoryId() == $row['categoryId'] && $setting->getId() == $row['id']){
					$setting->setValue($row['value']);
					$setting->setPreviousValue($row['value']);
				}
			}
		}

		return $settings;
	}

	public function getDefaultSettings(){
		#we do this in general.inc.php so whe can cache..
		$settingsRaw = getModuleDefaultSettings($this->module, $this->adminmodule);
		$thisSettings = array();
		foreach($settingsRaw as $setting) {
			$factory = new SettingFactory();
			$setting = $factory->getSetting($this->getCategoryId(), $setting);
			$thisSettings[$setting->getIdentificationString()] = $setting;
		}
		return $thisSettings;
	}

	public function getSetting($identifier, $catIndependent=False){
		foreach ($this->getAllSettings() as $setting){
			$checkIdentifier = $catIndependent ? $setting->getId() : $setting->getIdentificationString();
			if($identifier == $checkIdentifier){
				return $setting;
			}
		}
	}

	public function saveSetting($setting){
		if($setting->isChanged()){
			global $mydb;
			$query = "DELETE FROM um_category2settings WHERE categoryId = '".$setting->getCategoryId(). "' AND id = '".$setting->getId()."'";
			$mydb->executeQuery($query);
			$data = $setting->getTemplateData();
			$mydb->insertRecord($data, "um_category2settings");
		}
	}

	public function getPermissions(){
		$path = array();
		$path[BASEPATH."modules/".$this->module."/permissions.inc.php"] = false;
		$path[BASEMODULESPATH."modules/".$this->module."/permissions.inc.php"] =false;
		$path[BASEPATH."modules/".$this->adminmodule."/permissions.inc.php"] = true;
		$path[BASEMODULESPATH."modules/".$this->adminmodule."/permissions.inc.php"] = true;
		$permissions = array();
		foreach ($path as $pathkey => $pathvalue){
			if (file_exists($pathkey)) {
				$permissionNames = array();
				include($pathkey);
				foreach ($permissionNames as $key => $value){
					$perm = new Permission($this->getCategoryId(), $value, false);
					$permissions[$perm->getIdentificationString()] = $perm;
				}
			}		
		}

        if($this->categoryId != "0"){
      		$perm = new Permission($this->getCategoryId(), "view", false);
          	$permissions[$perm->getIdentificationString()] = $perm;
        }
		return $permissions;
	}

	private function getFilesFromDatabase(){
		global $mydb, $contentConf;
		static $catFiles = array();
		$this->files=array();
		if($this->category_files_table != ""){
	//		if(isset($catFiles[$this->categoryId]) and !$this->clearCache) { //Dit was beter ... :-) Zie andere comment.
			if(isset($catFiles[$this->categoryId])) {
				$this->files = $catFiles[$this->categoryId];
			} else {
				$records = $mydb->getRecords($this->category_files_table, "item_id", $this->categoryId);
				while($record = mysql_fetch_array($records)) {
					$num = $record['num'];
					$this->files[$num] = $record;
				}
				$catFiles[$this->categoryId] = $this->files;
			}
		}
	}

	public function getFiles(){
		return $this->files;
	}

	function getCategoryPath() {
		$categoryPath = '';
		$thisparent_id = $this->categoryId;
		while($thisparent_id != 0) {
			$thiscat = $this->getParentUrlNameAndParentId($thisparent_id);
			$name = $thiscat[0];
			$categoryPath = $name."/$categoryPath";
			$thisparent_id = $thiscat[1];
		}
		return trim($categoryPath,'/');
	}
	function toggleHide(){
		global $mydb;
		$q = "update ".$this->categories_table." set hide = 1 - hide where category_id = '".$this->categoryId."'";
		$new = !$this->hide;
		$this->hide = $new;
		$mydb->executeQuery($q);
	}

	function setPublic(){
		global $mydb;
		$this->public = 1;
	}

	function togglePublic(){
		global $mydb;
		$q = "update ".$this->categories_table." set public = 1 - public where category_id = '".$this->categoryId."'";
		$new = !$this->public;
		$this->public = $new;
		$mydb->executeQuery($q);
	}

	function setLevel($level){
		$this->level = $level;
	}

	function getPrio(){
		return $this->prio;
	}

	function getParentUrlNameAndParentId($thisparent_id) {
		global $mydb;

		static $cache = array();

		if(isset($cache[$thisparent_id])){
			return($cache[$thisparent_id]);
		}

		$language = $this->language;
		if($thisparent_id == 0) {
			$cache[$thisparent_id] = array('',0);
			//return array('', 0);
			return $cache[$thisparent_id];
		}

		$query = "select a.urlname,b.parent_id from ".$this->category_texts_table." as a join ".$this->categories_table." as b using(category_id) where a.language = '$language' and a.category_id = '".$thisparent_id."'";
		$result = $mydb->executeQuery($query);
		if(!mysql_num_rows($result)) {
			$query = "select a.urlname,b.parent_id from ".$this->category_texts_table." as a join ".$this->categories_table." as b using(category_id) where a.language = '".DEFAULT_LANGUAGE."' and a.category_id = '".$thisparent_id."'";
			$result = $mydb->executeQuery($query);
		}
		if(!mysql_num_rows($result)) {
			$query = "select a.urlname,b.parent_id from ".$this->category_texts_table." as a join ".$this->categories_table." as b using(category_id) where a.category_id = '".$thisparent_id."' limit 1";
			$result = $mydb->executeQuery($query);
		}
		if(!mysql_num_rows($result)) {
			//return array('', 0);
			$cache[$thisparent_id] = array('',0);
			return $cache[$thisparent_id];
		}
		$parentcat = mysql_fetch_object($result);
		$cache[$thisparent_id] = array($parentcat->urlname,$parentcat->parent_id);
//		return array($parentcat->urlname,$parentcat->parent_id);
		return $cache[$thisparent_id];
	}

	function getParentUrlName() {
		global $mydb;
		$thiscat = $this->getParentUrlNameAndParentId($this->parentId);
		return $thiscat[0];
	}
	function setCategoryId($id) {
		$this->categoryId = $id;
	}

	function isHidden(){
		return $this->hide;
	}

	function isPublic(){
		return $this->public;
	}

	function getParentId(){
		return $this->parentId;
	}

	function setParentId($parentId){
		# TODO misschien nog een check of the paretn wel bestaat?
		$this->parentId = $parentId;
	}

	function getCategoryId(){
		# TODO return False if isNew is set
		return $this->categoryId;	
	}

	function getModule(){
		return $this->module;	
	}
	
	public function getLevel(){
		return $this->level;
	}

	public function getHookName(){
		return $this->hookName;	
	}

	public function setHookName($hookName){
		$this->hookName = $hookName;
	}	

	public function getStyleclass(){
		return $this->styleclass;	
	}

	public function setStyleclass($styleclass){
		$this->styleclass = $styleclass;
	}	
	public function getTemplate(){
		return $this->template;	
	}

	public function setTemplate($template){
		$this->template = $template;
	}	
	public function getAdminModule(){
		if($this->adminmodule == '') {
			return 'emptyadminmodule';
		}
		return $this->adminmodule;	
	}

	public function setAdminModule($module){
		$this->adminmodule = $module;
	}	

	public function setModule($module){
		$this->module = $module;
	}	

	public function setHidden($hide){
		$this->hide = $hide;
	}

	public function getTemplateData(){
		return $this->getXTemplateData();
	}
	public function getXTemplateData(){
		$data = array();
		$data['category_id'] = $this->categoryId;
		$data['parent_id'] = $this->parentId;
		$data['prio'] = $this->prio;
		$data['hide'] = $this->hide;
		$data['public'] = $this->public;
		$data['urlname'] = $this->getUrlName();
		$data['template'] = $this->template;
		$data['module'] = $this->module;
		$data['adminmodule'] = $this->adminmodule;
		$data['name'] = $this->getName();
		$data['page_title'] = $this->getPageTitle();
		$data['styleclass'] = $this->styleclass;
		$data['hookName'] = $this->hookName;
		$data['metaDescription'] = $this->getMetaDescription();
		$data['metaKeywords'] = $this->getMetaKeywords();
		$data['language'] = $this->language;
		$data['link'] = $this->getName();
		$data['level'] = $this->level;
		$data['parenturlname'] = $this->getParentUrlName();
		$data['categorypath'] = $this->getCategoryPath();
		return $data;
	}
	public function setLanguage($language){
		# creeert een categorylanguage object voor de betreffende taal
		# iedere [s|g]etName/[s|g]etPageTitle gebeurt dan op dat object
		if($language == '') {
			$language = DEFAULT_LANGUAGE;
		}
		$this->language = $language;
		if(!isset($this->languages[$language])) {
			$this->languages[$language] = new CategoryLanguage($this->categoryId, $language);
		}
		$this->languageObject = $this->languages[$language];
	}
	public function getMetaDescription(){
		return $this->languageObject->getMetaDescription();
	}
	public function getMetaKeywords(){
		return $this->languageObject->getMetaKeywords();
	}
	public function getName(){
		return $this->languageObject->getName();
	}
	public function setName($name){
		$this->languageObject->setName($name);
	}


	public function getPageTitle(){
		if(trim($this->languageObject->getPageTitle())!=""){
			return $this->languageObject->getPageTitle();
		} else {
			return $this->getName();
		}
	}
	public function setMetaDescription($desc){
		$this->languageObject->setMetaDescription($desc);
	}
	public function setMetaKeywords($keys){
		$this->languageObject->setMetaKeywords($keys);
	}
	public function setPageTitle($pageTitle){
		$this->languageObject->setPageTitle($pageTitle);
	}
	public function getUrlName(){
		return $this->languageObject->getUrlName();
	}
	public function delete(){
		global $mydb;
		$mydb->deleteRecord($this->categories_table, 'category_id', $this->categoryId);
		$mydb->deleteRecord($this->category_texts_table, 'category_id', $this->categoryId);
		$d = array();
		$d['parent_id']	= $this->parentId;
		$mydb->updateRecord($d, $this->categories_table, 'parent_id', $this->categoryId);
		$query = "DELETE FROM um_category2settings WHERE categoryId = '".$this->categoryId. "'";
		$mydb->executeQuery($query);
		$query = "DELETE FROM um_user2settings WHERE categoryId = '".$this->categoryId. "'";
		$mydb->executeQuery($query);
		$query = "DELETE FROM um_user2permissions WHERE categoryId = '".$this->categoryId. "'";
		$mydb->executeQuery($query);
		$query = "DELETE FROM um_group2settings WHERE categoryId = '".$this->categoryId. "'";
		$mydb->executeQuery($query);
		$query = "DELETE FROM um_group2permissions WHERE categoryId = '".$this->categoryId. "'";
		$mydb->executeQuery($query);
		
	}

	public function deleteFile($num){
		global $mydb, $contentConf;
		//TODO:delete/unlink file from harddrive
		$query = "delete from category_files where num = '".$num."' and item_id = '".$this->categoryId."'";
		$mydb->executeQuery($query);
		$this->getFilesFromDatabase();
	}


	public function save(){
		global $mydb;
		# save category data op in tabel en 
		$data = array();
		$data['parent_id'] = $this->parentId;
		$data['prio'] = $this->prio;
		$data['hide'] = ($this->hide ? '1': '0');
		$data['public'] = ($this->public ? '1': '0');
		if(isset($this->styleclass)) {
			$data['styleclass'] = $this->styleclass;
		}
		if(isset($this->hookName)) {
			$data['hookName'] = $this->hookName;
		}
		$data['template'] = $this->template;
		$data['adminmodule'] = $this->adminmodule;
		$data['module'] = $this->module;
		$data['edittime'] = time();

		
		if($this->isNew) {
			# check if name exists with this parent
			$catNameExists = False;
			foreach($this->languages as $language => $languageObject) {
				$query = sprintf("select a.category_id From %s as a join %s as b using(category_id) where a.name = '%s' and a.language = '%s' and b.parent_id = '%s'",
					$this->category_texts_table, $this->categories_table, $languageObject->getName(), $language, $this->parentId);
				$result = $mydb->executeQuery($query);
				if(mysql_num_rows($result)) {
					$this->errorMsg = 'categoryExists';
					return False;
				}
			}
			#insert -> get insertId
			$this->categoryId = $mydb->insertRecord($data, $this->categories_table);
		} else {
			# update
			$mydb->updateRecord($data, $this->categories_table, 'category_id', $this->categoryId);
		}
		# voor ieder language object in languages roep save aan
		foreach($this->languages as $language => $languageObject) {
			if($this->isNew) {
				$languageObject->setCategoryId($this->categoryId);
			}
			$languageObject->save();
		}
		$this->isNew = False;
		return True;
	}


}
?>
