<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 27-09-07
 * date modified		: $Id: CategoryLanguage.class.php 114 2007-10-12 07:53:25Z erik $
 */

class CategoryLanguage {
	private $categoryId;
	private $language;
	private $name;
	private $urlName;
	private $pageTitle;
	private $metaDescription;
	private $metaKeywords;
	
	public function __construct($categoryId, $language) {
		$this->category_texts_table = 'category_texts';
		$this->categoryId = $categoryId;
		if($language == '') {
			$language = DEFAULT_LANGUAGE;
		}
		$this->language = $language;
		$this->getData();
	}
	public function setCategoryId($categoryId) {
		$this->categoryId = $categoryId;
	}

	private function generateUrlName(){
		$urlName = str_replace(' ','_', $this->name);
		$urlName = str_replace(".",'', $urlName);
		$urlName = urlencode($urlName);
		$urlName = ereg_replace("%[0-9A-F][0-9A-F]",'_', $urlName);
		$urlName = ereg_replace("_+",'_', $urlName);
		$this->urlName = $urlName;
	}

	public function getName(){
		return $this->name;
	}
	public function setName($name){
		$this->name = trim($name);
		$this->generateUrlName();
	}
	public function getPageTitle(){
		return $this->pageTitle;
	}
	public function setPageTitle($title){
		$this->pageTitle = trim($title);
	}

	public function getMetaKeywords(){
		return $this->metaKeywords;
	}

	public function getMetaDescription(){
		return $this->metaDescription;
	}

	public function getUrlName(){
		if ($this->urlName == '') {
			$this->generateUrlName();
		}
		return $this->urlName;
	}
	public function getLanguage(){
		return $this->language;
	}
	public function setLanguage($language){
		$this->language = $language;
	}

	public function setMetaKeywords($keywords){
		$this->metaKeywords = $keywords;
	}

	public function setMetaDescription($description){
		$this->metaDescription = $description;
	}

	private function getData() {
		global $mydb;
		static $catData = array();
		if(isset($catData[$this->categoryId][$this->language])) {
			$data = $catData[$this->categoryId][$this->language];
		} else if($this->categoryId) {
			$query = "select name,page_title,urlname, metaDescription, metaKeywords from ".$this->category_texts_table." where category_id = '".$this->categoryId."' and language = '".$this->language."'";
			$result = $mydb->executeQuery($query);
	
			if(mysql_num_rows($result)) {
				# yes this cat has its language translation
				$data = mysql_fetch_object($result);
				$catData[$this->categoryId][$this->language] = $data;
			} else {
				$query = "select name,page_title,urlname, metaDescription, metaKeywords from ".$this->category_texts_table." where category_id = '".$this->categoryId."' and language = '".DEFAULT_LANGUAGE."'";
				$result = $mydb->executeQuery($query);
	
				if(mysql_num_rows($result)) {
					# yes this cat has its default_language translation
					$data = mysql_fetch_object($result);
					$catData[$this->categoryId][$this->language] = $data;
				} else {
					# no this cat doesnt have its default_language translation try to get just one result
					$query = "select name,page_title,urlname, metaDescription, metaKeywords from ".$this->category_texts_table." where category_id = '".$this->categoryId."' limit 1";
					$result = $mydb->executeQuery($query);
					if(mysql_num_rows($result)) {
						$data = mysql_fetch_object($result);
						$catData[$this->categoryId][$this->language] = $data;
					}
				}
			}
		}
		if(isset($data)) {
			$this->setName(stripslashes($data->name));
			$this->setPageTitle(stripslashes($data->page_title));
			$this->setMetaKeywords(stripslashes($data->metaKeywords));
			$this->setMetaDescription(stripslashes($data->metaDescription));
			$this->generateUrlName();
		}
	}
	public function delete() {
		global $mydb;
		$query = "delete from ".$this->category_texts_table." where language = '".$this->language."' and category_id = '".$this->categoryId."' limit 1";
		$mydb->executeQuery($query);
	}

	public function save() {
		global $mydb;
		if($this->name != '' ) {
			$data = array();
			$data['category_id'] = $this->categoryId;
			$data['name'] = $this->name;
			$data['page_title'] = $this->pageTitle;
			$data['metaDescription'] = $this->metaDescription;
			$data['metaKeywords'] = $this->metaKeywords;
			$data['urlname'] = $this->getUrlName();
			$data['language'] = $this->language;
			$mydb->replaceRecord($data, $this->category_texts_table);
		}
	}
}
?>
