<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT	
 * date created			: 10-09-07
 * date modified		: $Id: CategoryManager.class.php 171 2007-10-24 21:24:12Z erik $
 */

class CategoryManager {
	private $categories_table = 'categories';
	private $category_texts_table = 'category_texts';

	private $startCategoryId = 0;
	private $selectedCategoryId = 0;
	private $selectedCategoryIdTree = array();
	private $selectedCategoryTree = array();
	private $expandLevel = 0;
	private $startLevel = False;
	private $endLevel = False;
	private $showHidden = False;
#	private $orderField  = 'prio,name';
	private $orderField  = 'prio';
	private $fullCategoryIdTree = array();
	private $clearCache  = False;

	public function __construct($catconf = false) {
		$this->getCategoryIdsRecursive(0, 0, array(), True);
		if($catconf){
			if(isset($catconf['categories_table'])){
				$this->categories_table = $catconf['categories_table'];
			}

			if(isset($catconf['categories_texts_table'])){
				$this->categories_texts_table = $catconf['categories_table_table'];
			}

			if(isset($catconf['toplevel'])){
				$this->setStartCategoryId($catconf['toplevel']);
			}

			#if(isset($catconf['show_hidden'])){
			#	$this->showHidden($catconf['show_hidden']);
			#}
		}
	}
	public function clearCache() {
		$this->clearCache = True;
	}

	public function showHidden($hide) {
		$this->showHidden = ($hide ? True : False);
	}

	public function setOrderField($orderfield) {
		$this->orderField = $orderfield; # 
	}

	public function setStartCategoryId($categoryId=0) {
		# this is the category to start the tree from when requested
		$this->startCategoryId = $categoryId;
	}
	public function setSelectedCategoryId($categoryId) {
		$this->selectedCategoryId = $categoryId;
		# the tree is expanded to this category
	}
	public function setExpandLevel($level) {
		# expand level. From root down expand the tree to this level
		$this->expandLevel = $level;
	}
	public function setStartLevel($level) {
		# show categories starting from this level down
		$this->startLevel = $level;
	}
	public function setEndLevel($level) {
		# show categories till this level
		$this->endLevel = $level;
	}
	public function selectCategoryIdTree() {
		# get select tree
		# get full tree for sequence
		# fill finaltree with expandlevel and select tree
		$selectTree = $this->resolveCategoryTreeFromId($this->selectedCategoryId);
		$this->getCategoryIdsRecursive($this->startCategoryId, 0, $selectTree);
		foreach($this->fullCategoryIdTree as $categoryId => $level) {
			if($level <= $this->expandLevel or in_array($categoryId, $selectTree)) {
				if((is_bool($this->endLevel) and $this->endLevel !== False) or (!is_bool($this->endLevel) and  $level > $this->endLevel)) {
					continue;
				}
				if((is_bool($this->startLevel) and $this->startLevel !== False) or (!is_bool($this->startLevel) and  $level < $this->startLevel)) {
					continue;
				}
				$this->selectedCategoryIdTree[$categoryId] = $level;
			}
		}
	}
	public function getSelectedCategoryIdTree() {
		$this->selectCategoryIdTree();
		return $this->selectedCategoryIdTree;
	}
	public function getSelectedCategoryTreeForPrinting() {
		global $mydb;
		$this->selectedCategoryTree = array();
		$this->selectCategoryIdTree();

		if(count($this->selectedCategoryIdTree)) {
			$selectedCatPath = $this->getCategoryIdPathFromId();
			$l = isset($_SESSION['language']) ? $_SESSION['language'] : DEFAULT_LANGUAGE;
			$query = "Select a.*,b.public from category_texts as a JOIN categories as b USING(category_id) where language = '".$l."' AND category_id IN (".join(',', array_keys($this->selectedCategoryIdTree)).")";
			$catDataResult = $mydb->executeQuery($query);
			$catData = array();
			while($c = mysql_fetch_array($catDataResult)) {
				$catData[$c['category_id']] = $c;
			}

			foreach($this->selectedCategoryIdTree as $categoryId => $level) {
				$d = $catData[$categoryId];
				$d['level'] = $level;
				$d['selected'] = False;
				if(in_array($categoryId, $selectedCatPath)) {
					$d['selected'] = True;
				}
				$this->selectedCategoryTree[] = $d;
			}
		}
		return $this->selectedCategoryTree;
	}

	public function getSelectedCategoryTree() {
		# TODO caching? 
#		static $selectedCategoryTree = array();
#		if(count($selectedCategoryTree)) {
#			return $selectedCategoryTree;
#		}
		$this->selectedCategoryTree = array();
#echo microtime(True)." 2<br>";
		$this->selectCategoryIdTree();
#print_r($this->selectedCategoryIdTree);
#echo microtime(True)." 3<br>";
		foreach($this->selectedCategoryIdTree as $categoryId => $level) {
#echo microtime(True)." before ";
			$category = new Category($categoryId);
#echo microtime(True)." aft<br>";
			if($this->clearCache) {
				$category->clearCache();
			}
			$category->setLevel($level);
			$this->selectedCategoryTree[] = $category;
		}
#		$selectedCategoryTree = $this->selectedCategoryTree;
#echo microtime(True)." 4<br>";
		return $this->selectedCategoryTree;
	}
	
	private function getCategoryIdsRecursive($parentId=0, $level=0, $selectTree=False, $reset=False) {
		# tree[id] = level;
		global $mydb, $language;
		static $catTree = array();
		if($reset) {
			$catTree = array();
			return;
		}
		if(isset($catTree[$parentId]) and !$this->clearCache) {
			# did this before
			$this->fullCategoryIdTree = $catTree[$parentId];
			return;
		}
		$orderby = " order by ".$this->orderField; # TODO
		$oFields = split (",", $this->orderField);
		$textTableFields = array('name', 'page_title', 'urlname', 'language', 'metaDescription', 'metaKeywords');

		$useJoin = false;
		foreach ($oFields as $oField) {
			if(in_array(trim($oField), $textTableFields)) {
				$useJoin = true;
				break;
			}
		}
		if($useJoin) {
			$query = "select a.category_id,a.hide from ".$this->categories_table." as a join ".$this->category_texts_table." using(category_id) where parent_id = '$parentId' and language = '".$language."' $orderby";
			$cats = $mydb->executeQuery($query);
			if(!mysql_num_rows($cats)) {
				$query = "select a.category_id,a.hide from ".$this->categories_table." as a join ".$this->category_texts_table." using(category_id) where parent_id = '$parentId' and language = '".DEFAULT_LANGUAGE."' $orderby";
				$cats = $mydb->executeQuery($query);
			}
		} else {
			$cats = $mydb->getRecords($this->categories_table, 'parent_id', $parentId, 'category_id,hide', $orderby);	
		}
		if(mysql_num_rows($cats)) {
			while($cat = mysql_fetch_object($cats)) {
				if($cat->hide && !$this->showHidden) {
					continue;
				}
				$this->fullCategoryIdTree[$cat->category_id] = $level;
				$nextlevel = $level + 1;
				if($this->endLevel >0 and $nextlevel > $this->endLevel) {
					continue;
				}
				if($selectTree) {
					if($level < $this->endLevel and !in_array($cat->category_id, $selectTree)) {
						continue;
					}
				}
#			echo $this->endLevel." !== False and $nextlevel == ".$this->endLevel."<br>\n";
				$this->getCategoryIdsRecursive($cat->category_id, $nextlevel, $selectTree);
			}
		}
		$catTree[$parentId] = $this->fullCategoryIdTree;
	}
	
	public function resolveCategoryPath($categoryPathparts) {
$debug = false;
		$categoryIdPath = array();
		$numCats = count($categoryPathparts);
		$thisLevel = 0;
		foreach($categoryPathparts as $level => $categoryPathpart) {
if($debug) echo $categoryPathpart;
			$categoryIds[$level] = $this->getCategoryIdFromURLname($categoryPathpart);
			$thisLevel = $level;
		}
if($debug) echo "<br>\nmogelijke categorien ids per level (huidige level: $thisLevel):<br>\n";
if($debug) print_r($categoryIds);
		for($catlevel = 0; $catlevel < $numCats; $catlevel++) {
			if(count($categoryIds[$catlevel]) > 1) {
if($debug) echo "<br>\n<br>\nmogelijke categorien in dit level($catlevel):<br>\n";
if($debug) print_r($categoryIds[$catlevel]);
				# meerdere childs mogelijk
				foreach($categoryIds[$catlevel] as $categoryId) {
					# check van ieder child de parent
					$childsparentId = $this->getParentIdFromId($categoryId);
					$upperCatLevel = $catlevel - 1;
					if($upperCatLevel == -1){
						$upperCatLevel = 0;
					}
if($debug) echo "<br>\nchilds parent: $childsparentId, parent to check: ".$categoryIdPath[$upperCatLevel];
					if((isset($categoryIdPath[$upperCatLevel]) and ($childsparentId == $categoryIdPath[$upperCatLevel])) or ($childsparentId == 0 && $catlevel == 0)) {
if($debug) echo "<br>\nMATCH: $childsparentId == ".$categoryIdPath[$upperCatLevel];
						$categoryIdPath[] = $categoryId;
						break;
					}
				}
			} else {
				if(count($categoryIds[$catlevel])) {
					$categoryIdPath[] = $categoryIds[$catlevel][0];
				} else {
					$categoryIdPath[] = '';
				}
			}
		}
if($debug) echo "<br>\nresultaat:<br>\n";
if($debug) print_r($categoryIdPath);
		return $categoryIdPath;
	}

	public function resolveCategoryTreeFromId($cat_id) {
		global $mydb, $catconf;
		$cattree = array();
		# get cats which have me as parent e.g. who are my children!?
		$cats = $mydb->getRecords($this->categories_table, 'parent_id', $cat_id, 'category_id');
		while($cat = mysql_fetch_object($cats)) {
			$cattree[] = $cat->category_id;
		}
		# recursive get all (grand)parents from this cat
		$this->getRecursiveParentId($cat_id, $cattree);
		return $cattree;
	}

	public function getCategoryPathFromId($categoryId) {
		$categoryIdPath = $this->getCategoryIdPathFromId($categoryId);
		$pathParts = array();
		foreach($categoryIdPath as $id) {
			$pathPart = $this->getURLnameFromCategoryId($id);
			if($pathPart) {
				$pathParts[] = $pathPart;
			}
		}
		return join('/', $pathParts);
	}
	public function getCategoryIdPathFromId($thisCategoryId=False) {
		global $mydb, $catconf;
		$categoryId = $this->selectedCategoryId;
		if($thisCategoryId) {
			$categoryId = $thisCategoryId;
		}
		$parentIdPath = array($categoryId);
		$parentId = $categoryId;
		$tel = 0;
		while($parentId != $this->startCategoryId) {
			$parentId = $this->getParentIdFromId($parentId);
			$parentIdPath[] = $parentId;
			$tel++;
			if($tel == 10) {
				break;
			}
		}
		return array_reverse($parentIdPath);
	}

	private function getRecursiveParentId($cat_id, &$cattree) {
		global $mydb, $catconf;
		$cats = $mydb->getRecords($this->categories_table, 'category_id', $cat_id, 'parent_id');
		$cat = mysql_fetch_object($cats);
		if ($cat != null ) {
			$cats2 = $mydb->getRecords($this->categories_table, 'parent_id', $cat->parent_id, 'category_id');
			while($cat2 = mysql_fetch_object($cats2)) {
				$cattree[] = $cat2->category_id;
			}
			$this->getRecursiveParentId($cat->parent_id, $cattree);
		}
	}

	public function getParentIdFromId($categoryId) {
		global $mydb;
		if($categoryId == 0) {
			return 0;
		}
		$query = "select parent_id from ".$this->categories_table." where category_id = '$categoryId' limit 1";
		$result = $mydb->executeQuery($query);
		if(!mysql_num_rows($result)) {
			return 0;
		}
		$c = mysql_fetch_object($result);
		return $c->parent_id;
	}
	public function getAllChildrenIdsFromId($categoryId) {
		$subCategoryIds = array();
		$this->getChildrenIds($categoryId, $subCategoryIds);
		return $subCategoryIds;
	}

	public function getCategoryIdByAdminModule($parentId = 0, $moduleName = ""){
		$children = $this->getAllChildrenIdsFromId($parentId);
		foreach($children as $childId) {
			$child = new Category($childId);
			if($child->getAdminModule() == $moduleName) {
				return $childId;
			}
		}
		return false;
	}

	public function getChildrenIds($categoryId, &$ids, $dontRecurse=False) {
		global $mydb;
		$query = "select category_id,parent_id from ".$this->categories_table." where parent_id = '$categoryId' order by prio";
		$result = $mydb->executeQuery($query);
		if(mysql_num_rows($result)) {
			while($c = mysql_fetch_object($result)) {
				$ids[] = $c->category_id;
				if(!$dontRecurse) {
					$this->getChildrenIds($c->category_id, $ids);
				}
			}
		}
	}
	public function getChildrenIdsFromId($categoryId, $dontRecurse=False) {
		$subCategoryIds = array();
		$this->getChildrenIds($categoryId, $subCategoryIds, $dontRecurse);
		return $subCategoryIds;
	}

	public function getFirstCategoryIdForUser($user, $parentId=0) {
		global $mydb;
#		$query = "select category_id from ".$this->categories_table." where parent_id = '$parentId' order by prio limit 1";
		$query = "select a.category_id from ".$this->categories_table." as a join um_user2permissions as b on category_id = categoryId join um_users as c using(userId) where c.username = '$user' and b.name = 'view' and b.value='1' order by a.category_id ";
#echo $query;
		$result = $mydb->executeQuery($query);
		if(mysql_num_rows($result)) {
			$c = mysql_fetch_object($result);
			return $c->category_id;
		} else {
			return 0;
		}
	}
	public function getFirstCategoryIdForUserId($userId, $parentId=0) {
		global $mydb;
#		$query = "select category_id from ".$this->categories_table." where parent_id = '$parentId' order by prio limit 1";
		if($userId == 1) {	# super user
			$query = "select a.category_id from ".$this->categories_table." as a  order by a.prio ASC";
		} else {
			$query = "select a.category_id from ".$this->categories_table." as a join um_user2permissions as b on category_id = categoryId where b.userId = '$userId' and b.name = 'view' and b.value='1' order by a.category_id ";
		}
		$result = $mydb->executeQuery($query);
		if(mysql_num_rows($result)) {
			$c = mysql_fetch_object($result);
			return $c->category_id;
		} else {
			return 0;
		}
	}

	public function getFirstPublicCategoryId() {
		global $mydb;
		$query = "select category_id from ".$this->categories_table." where parent_id = '0' and public = '1' order by prio limit 1";
		$result = $mydb->executeQuery($query);
		if(mysql_num_rows($result)) {
			$c = mysql_fetch_object($result);
			return $c->category_id;
		} else {
			return 0;
		}
	}

	public function getFirstCategoryId($parentId=0) {
		global $mydb;
		$query = "select category_id from ".$this->categories_table." where parent_id = '$parentId' order by prio limit 1";
		$result = $mydb->executeQuery($query);
		if(mysql_num_rows($result)) {
			$c = mysql_fetch_object($result);
			return $c->category_id;
		} else {
			return 0;
		}
	}

	public function getURLnameFromCategoryId($categoryId) {
		global $mydb, $language;
		# TODO caching
		$query = "select urlname from ".$this->category_texts_table." where category_id = '$categoryId' and language = '$language'";
		$result = $mydb->executeQuery($query);

		if(!mysql_num_rows($result)){
			$query = "select urlname from ".$this->category_texts_table." where category_id = '$categoryId' and language = '".DEFAULT_LANGUAGE."'";
			$result = $mydb->executeQuery($query);
		}

		if(!mysql_num_rows($result)){
			$query = "select urlname from ".$this->category_texts_table." where category_id = '$categoryId' limit 1";
			$result = $mydb->executeQuery($query);
		}

		if(mysql_num_rows($result)) {
			$c = mysql_fetch_object($result);
			return $c->urlname;
		}
		return '';
	}
	public function getCategoryIdFromURLname($categoryURLname) {
		global $mydb, $language;
		$category_ids = array();
		if(isset($_SESSION['language'])) {
			$language = $_SESSION['language'];
		}
		$query = "select category_id from ".$this->category_texts_table." where urlname = '$categoryURLname' and language = '$language'";
		$result = $mydb->executeQuery($query);
		if(!mysql_num_rows($result)){
			$query = "select category_id from ".$this->category_texts_table." where urlname = '$categoryURLname' and language = '".DEFAULT_LANGUAGE."'";
			$result = $mydb->executeQuery($query);
		}
		if(!mysql_num_rows($result)){
			$query = "select category_id from ".$this->category_texts_table." where urlname = '$categoryURLname' limit 1";
			$result = $mydb->executeQuery($query);
		}
		
		while($c = mysql_fetch_object($result)) {
			$category_ids[] = $c->category_id;
		}
		
		return $category_ids;
	}

	public function countChildrenFromParentId($parentId) {
		global $mydb;
		static $childcounts = array();
		#if(array_key_exists($parentId, $childcounts) and !$this->clearCache) { //Op 18 maart dachten we dat dit beter was om hier geen clear cache te hebben >:) Als hier nu een bug zit, schop jochem, zijn schuld!
		if(array_key_exists($parentId, $childcounts)) {
			return $childcounts[$parentId];
		}
		$query = "select count(category_id) as childcount from ".$this->categories_table." where parent_id = '".$parentId."'";
		$result = $mydb->executeQuery($query);
		list($childCount) = mysql_fetch_array($result);
	 	$childcounts[$parentId] = $childCount;
		return $childCount;
	}

	public function moveCategoryPosition($categoryId, $direction) {
		global $mydb;
		# direction = up/down
		$parentId = $this->getParentIdFromId($categoryId);
    	$records = $mydb->getRecordsArray($this->categories_table, 'parent_id', $parentId, 'category_id', 'order by prio');
	    $records = reorder($records, $direction, $categoryId, 'category_id');
	    foreach($records as $prio => $record) {
			$d = array();
	        $d['prio'] = $prio;
	        $mydb->updateRecord($d, $this->categories_table, 'category_id', $record['category_id']);
	    }
	}

	function getAvailableTemplates($moduledir) {
		static $templates = array();
		$moduletemplates = array();
		if(!isset($templates[$moduledir])){
			$templates[$moduledir] = array();
		}
		if(!count($templates[$moduledir])) {
			$this->checktemplatedir(&$moduletemplates, BASEMODULESPATH."modules/$moduledir/templates");
			$this->checktemplatedir(&$moduletemplates, BASEMODULESPATH."modules/$moduledir/configs");
			$this->checktemplatedir(&$moduletemplates, BASEPATH."modules/$moduledir/templates");
			$this->checktemplatedir(&$moduletemplates, BASEPATH."modules/$moduledir/configs");
			ksort($moduletemplates);
			$templates[$moduledir] = $moduletemplates;
		} else {
			$moduletemplates = $templates[$moduledir];
		}
		return $moduletemplates;
	}

	function checktemplatedir($templates, $dir) {
		if(is_dir($dir.'/')) {
	   		if ($handle = opendir($dir)) {
				while (false !== ($file = readdir($handle))) {
					if(ereg(".inc.html$", $file) or ereg(".inc.php$", $file)) {
						$template = ereg_replace(".inc.html$", '', $file);
						$template = ereg_replace(".inc.php$", '', $template);
						if($template == 'config' or $template == 'template'or $template == 'default_fields') {
							if(!in_array('Default', $templates)) {
								$templates['Default'] = 'Default';
							}
						} elseif (!in_array($template, $templates)) {
							$templates[$template] = $template;
						}
					}
				}
			}
			closedir($handle);
		}
	}

	public function getAllSettings(){
		$settings = array();
#		$catManager = new CategoryManager();
#		$catManager->setExpandLevel(999999);
#		$allCategoryIds = $catManager->getSelectedCategoryTree();
		$allCategoryIds = $this->getSelectedCategoryTree();
		foreach ($allCategoryIds as $category){
			$result = array_merge($category->getSettings(), $settings);
			$settings = $result;
		}
		return $settings;
	}

	//CHECKS WHETHER OR NOT IF THE CAT IS IN CACHE
	public function getCategory($categoryId){
        /*foreach ($this->getSelectedCategoryTree() as $category){
            if($category->getCategoryId() == $categoryId){
                return $category;
            }
        }*/
		return new Category($categoryId);
	}

	public function getAllPermissionsForCategory($categoryId){
		return $this->getCategory($categoryId)->getPermissions();
	}

	public function getAllCategories() {
		$this->setExpandLevel(999999);
		$this->showHidden(true);
		return $this->getSelectedCategoryTree();
	}
	
	public function getAllPermissions(){
		static $permissions = array();
		if(count($permissions) and !$this->clearCache) {
			return $permissions;
		}
		$this->setExpandLevel(999999);
		$this->showHidden(true);
		$allCategoryIds = $this->getSelectedCategoryTree();
		foreach ($allCategoryIds as $category){
			$result = array_merge($category->getPermissions(), $permissions);
			$permissions = $result;
		}
		return $permissions;
	}
}
?>
