<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT    
 * date created			: 10-10-07
 * date modified		: $Id: ContentManager.class.php 159 2007-10-23 15:29:44Z erik $
 */

class ContentManager {
	private $categoryId;
	private $contentItems;
	private $content_table;
	private $selectFromAllCategories;
	private $table_primairykey;
	private $contentConf;

	public function __construct($categoryId, $configPath = false, $contentConf = false) {
		if(file_exists($configPath)){
			include($configPath);
			$this->contentConf = $contentConf;
		} else if ($contentConf){
			$this->contentConf = $contentConf;
		} else if (($configPath && !file_exists($configPath)) && count($this->contentConf) == 0){
			echo "CONFIG FILE DOESNT EXIST! categoryId:$categoryId, configPath:$configPath; <BR>";
			exit;
		}
		$this->content_table = $this->contentConf['table'];
		$this->table_primairykey = $this->contentConf['table_primairykey'];
		$this->selectFromAllCategories =  (isset($this->contentConf['selectFromAllCategories']) && $this->contentConf['selectFromAllCategories'] ? True : False);
		$this->showItemsFromFirstSubcat = (isset($this->contentConf['showItemsFromFirstSubcat']) && $this->contentConf['showItemsFromFirstSubcat'] ? True : False);
		$this->showFirstItemFromSubcats = (isset($this->contentConf['showFirstItemFromSubcats']) && $this->contentConf['showFirstItemFromSubcats'] ? True : False);

		if(isset($this->contentConf['useParentCatIdForSelectedCat']) && $this->contentConf['useParentCatIdForSelectedCat'] == True) {
			$categoryManager = new CategoryManager();
			$categoryId = $categoryManager->getParentIdFromId($categoryId);
			unset($categoryManager);
		}
		$this->setSelectedCategoryId($categoryId);
	}
	public function getListtitle() {
		return $this->contentConf['listtitle'];
	}
	public function setSelectFromAllCategories($bool) {
		$this->selectFromAllCategories = ($bool ? True : False);
	}
	public function setSelectedCategoryId($categoryId) {
		$this->categoryId = $categoryId;
	}
	public function setEnableRandom($random) {
		$this->contentConf['enableRandom'] = $random;
	}
	public function getContentItemIds($searchFields = array(), $orderField=false, $orderDirection=false) {
		global $mydb;
		$this->contentItemIds = array();

		if (!$orderField && !$orderDirection) {
			$orderby = "order by prio"; # TODO orderField ?
			if(isset($this->contentConf['orderField'])){
				$orderby = "order by " . $this->contentConf['orderField'];
			}
			if(isset($this->contentConf['orderDirection'])){
				$orderby .= " " . $this->contentConf['orderDirection'];
			}
			if(isset($this->contentConf['showMaxItems'])) {
				$orderby .= " limit ".$this->contentConf['showMaxItems'];
			}
		} else {
			$orderby = "order by $orderField $orderDirection";
		}
		if($this->selectFromAllCategories) {
			$result = $mydb->getRecords($this->content_table, 'all', 'all', '*', $orderby, $searchFields);
		} else if($this->showItemsFromFirstSubcat or $this->showFirstItemFromSubcats) {
			# get childs
			$categoryManager = new categoryManager();
			$subCategoryIds = $categoryManager->getChildrenIdsFromId($this->categoryId);
			if($this->showItemsFromFirstSubcat) {
				if(count($subCategoryIds)) {
					list($firstSubCategory) = $subCategoryIds;
				} else {
					$firstSubCategory = $this->categoryId;
				}
				$result = $mydb->getRecords($this->content_table, "categoryId", $firstSubCategory, '*', $orderby, $searchFields);
			}
		} else {
			$result = $mydb->getRecords($this->content_table, "categoryId", $this->categoryId, '*', $orderby, $searchFields);
		}
		if($this->showFirstItemFromSubcats) {
			foreach($subCategoryIds as $categoryId) {
				$result = $mydb->getRecords($this->content_table, "categoryId", $categoryId, '*', $orderby.' limit 1', $searchFields);
				while($record = mysql_fetch_array($result)) {
					$this->contentItemIds[] = $record[$this->table_primairykey];
				}
			}
		} else {
			while($record = mysql_fetch_array($result)) {
				$this->contentItemIds[] = $record[$this->table_primairykey];
			}
		}
	}

	public function getContentItems($query ="", $orderField=false, $orderDirection=false) {
		$this->setSelectedCategoryId($this->categoryId);
		$contentItems = array();
		$this->getContentItemIds($query, $orderField, $orderDirection);
		$itemIds = $this->contentItemIds;
#var_dump($this->contentConf);
		if(isset($this->contentConf['enableRandom']) && $this->contentConf['enableRandom'] == 'True') {
			$itemIds_keys = array_rand($this->contentItemIds, $this->contentConf['randomItems']);
			$itemIds = array();
			if($this->contentConf['randomItems'] == 1) {
				$itemIds[] = $this->contentItemIds[$itemIds_keys];
			}else {
				foreach($itemIds_keys as $idKey) {
					$itemIds[] = $this->contentItemIds[$idKey];
				}
			}
		}
		foreach($itemIds as $itemId) {
			$contentItems[] = new Content($itemId, false, $this->contentConf);
		}
		return $contentItems;
	}
	public function getItemIdFromUrlName($name, $categoryId, $language) {
		global $mydb;
		$categoryManager = new CategoryManager();
		if($this->showItemsFromFirstSubcat) {
			# kijk ook in het eerste kind
			$subCategoryIds = $categoryManager->getChildrenIdsFromId($categoryId);
			if(count($subCategoryIds)) {
				list($extraCategoryId) = $subCategoryIds;
			}
		} else {
			# kijk in parent
			$extraCategoryId = $categoryManager->getParentIdFromId($categoryId);
		}
		$extraCategoryQuery = '';
		if(isset($extraCategoryId)) {
			$extraCategoryQuery = " OR category_id = '$extraCategoryId'";
		}
		$query = "select itemId from item_urls where (category_id = '$categoryId' $extraCategoryQuery) and language = '$language' and urlname = '$name'";
		$result = $mydb->executeQuery($query);
		if(!mysql_num_rows($result)) {
			$query = "select itemId from item_urls where (category_id = '$categoryId' $extraCategoryQuery) and language = '".DEFAULT_LANGUAGE."' and urlname = '$name'";
			$result = $mydb->executeQuery($query);
		}
		if(!mysql_num_rows($result)){
			return False;
		}
		list($itemId) = mysql_fetch_array($result);
		return $itemId;
	}

	public function moveContentItemPosition($itemId, $direction) {
		global $mydb;
		if($this->selectFromAllCategories) {
			$records = $mydb->getRecordsArray($this->content_table, 'all', 'all', $this->table_primairykey, "order by prio");
		} else {
			$records = $mydb->getRecordsArray($this->content_table, 'categoryId', $this->categoryId, $this->table_primairykey, "order by prio");
		}
		$records = reorder($records, $direction, $itemId, $this->table_primairykey);
        foreach($records as $prio => $record) {
            $d = array();
            $d['prio'] = $prio;
//			$mydb->verbose = true;
            $mydb->updateRecord($d, $this->content_table, $this->table_primairykey, $record[$this->table_primairykey]);
//			$mydb->verbose = false;
        }
		$this->getContentItemIds();
	}

	public function sortContent($contentItems, $value){
		$newContentItems = array();
		foreach($contentItems as $contentItem) {
			$newContentItems[] = $contentItem->getValue($value);
		}
		natsort($newContentItems);
		$sortedContentItems = array();
		foreach($newContentItems as $key => $value) {
				$sortedContentItems[] = $contentItems[$key];
		}
		return $sortedContentItems;
	}
	public function getUniqueItemId() {
		# retourneer het id voor deze cat
		# creeer een record als er nog geen bestaat
		# werkt alleen als 'totalItems' op 1 staat
		if($this->contentConf['totalItems'] != 1) {
			echo "getUniqueItemId method called but totalItems in config != 1";
			return 0;
		}
		$this->getContentItemIds();
		if(count($this->contentItemIds)) {
			return $this->contentItemIds[0];
		}
		$newContentItem = new Content(False, False, $this->contentConf);	
		$newContentItem->setCategoryId($this->categoryId);
		$newContentItem->save();
		return $newContentItem->getItemId();
	}
}
?>
