<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 04-10-07
 * date modified		: $Id: NormalField.class.php 165 2007-10-24 14:38:00Z erik $
 */

class DateField extends Field {
	private $value;
	public $error = False;
	private $dateFormat;
	
	public function __construct($fieldName, $defaultValue, $condition, $languageDependent, $value, $type, $preProcessFunctions=array(), $dateformat){
		parent::__construct($fieldName, $defaultValue, $condition, $languageDependent, $type, $preProcessFunctions);
		if($value) {
			$this->value = $value;
		}
		$this->dateFormat = $dateformat;
	}
	
	public function read(){
		if(isset($_REQUEST[$this->fieldName]) && !is_array($_REQUEST[$this->fieldName])) {
			$this->value = $_REQUEST[$this->fieldName];

		    $sd = split('-', $this->value);
		    $this->value = mktime(12, 0, 0, $sd[1], $sd[0], $sd[2]); # hmmm altijd om 12 uur..

			foreach($this->preProcessFunctions as $func) {
				$this->value = $func($this->value);
			}
			$this->validate();
		}
	}

	public function validate(){
		if($this->condition) {
			$valid = (preg_match($this->condition, $this->value));
			$this->error = !$valid;
		} else {
			$this->error=false;
		}
	}

	public function getDataValue(){
		return $this->value;
	}

	public function getValue(){
//		return stripslashes($this->value);
		return date($this->dateFormat, $this->value);
	}

	public function setCondition($condition){
		$this->condition = $condition;
	}
	public function setValue($value){
		$this->value = $value;
	}
	
	public function toString(){
		return "Fieldname: " . $this->fieldName . ", Value: " . $this->getValue();
	}
}

?>
