<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 28-09-07
 * date modified		: $Id: Field.class.php 116 2007-10-12 14:48:11Z ivo $
 */

abstract class Field {
	protected $fieldName;
	private $value;
	private $defaultValue;
	protected $condition;
	protected $preProcessFunctions;
	private $isLanguageDependent;
	protected $type;

	public function __construct($fieldName, $defaultValue, $condition, $isLanguageDependent, $type, $preProcessFunctions=array()){
		$this->fieldName = $fieldName;
		$this->defaultValue = $defaultValue;
		$this->condition = $condition;
		$this->preProcessFunctions = $preProcessFunctions;
		$this->isLanguageDependent = $isLanguageDependent;
		$this->type = $type;
		if($defaultValue) {
			$this->value = $defaultValue;
		}
	}

	public function getType(){
		return $this->type;
	}


	public function getFieldName(){
		return $this->fieldName;
	}

	public function isLanguageDependent(){
		return $this->isLanguageDependent;
	}
	
	abstract public function read();
	abstract public function toString();
	abstract public function validate();

	public function assign($rep, $value) {
		return true;	
	}
	public function getDataValue() {
		return $this->getValue();
	}
}	
?>
