<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT    
 * date created			: 11-06-08
 * date modified		: $Id$
 */

class FileBrowser {
	private $number = 0;
	private $cache = array();
	private $startPath = False;
	private $showHidden = False;
	private $listFiles = False;
	private $dirIndex = array();
	private $indexCount = 0;
	private $regexFilters = array();

	public function __construct($startPath, $templateFile) {
		if(isset($_SESSION["filebrowserCache"])){
			$this->cache = $_SESSION["filebrowserCache"];
		}
		$this->startPath = $startPath;
		$this->mod = new TemplateProxy($templateFile);
		$this->templateFile = $templateFile;
	}

	public function getDirFromIndex($index){
		return $_SESSION['fileBrowser']['dirIndex'][$index];
	}

	public function setShowHidden(){
		$this->showHidden = True;
	}

	public function setListFiles($val){
		$this->listFiles = $val;
	}

	public function createFileBrowserWithoutTemplate($fromCache = false){
		if($fromCache) {
			$this->dirIndex = $_SESSION['fileBrowser']['dirIndex'];
			return $_SESSION['fileBrowser']['output'];
		}
		if(is_dir($this->startPath)) {
			$this->dirIndex[1] = $this->startPath;
			$directory = new RecursiveDirectoryIterator($this->startPath);
			$dirlisting = $this->dirlist($directory);
			$MainDir['subdirs'] = $dirlisting;
			$MainDir['dirpath'] = $this->startPath;
			$MainDirlisting['/(root)'] = $MainDir;
		}
		return $MainDirlisting;
	}

	public function createFileBrowser($fromCache=False){
		if($fromCache) {
			$this->dirIndex = $_SESSION['fileBrowser']['dirIndex'];
			return $_SESSION['fileBrowser']['output'];
		}
		if(is_dir($this->startPath)) {
			$this->dirIndex[1] = $this->startPath;
			$directory = new RecursiveDirectoryIterator($this->startPath);
			$dirlisting = $this->dirlist($directory);
			$MainDir['subdirs'] = $dirlisting;
			$MainDir['dirpath'] = $this->startPath;
			$MainDirlisting['/(root)'] = $MainDir;
			$outputString = $this->genList($MainDirlisting);
			$_SESSION['fileBrowser']['output'] = $outputString;
			$_SESSION['fileBrowser']['dirIndex'] = $this->dirIndex;
		} else {
			$outputString = 'dir doesn\'t exists';
		}
		return $outputString;
	}

	public function genList ($dirlisting, $toplevel = true){
		$part = new TemplateProxy($this->templateFile);
		if($toplevel) {
			$part->parse("module.itemlist.toplevel");
		} else {
			$part->parse("module.itemlist.secondlevel");
		}
		foreach ($dirlisting as $dir => $dirData) {
			$size = $dirData['subdirs'];

			if(!is_array($size)) {
				$this->number ++;
				$this->dirIndex[$this->number] = $dirData['dirpath'];
				$part->assign("NUMBER", $this->number);
				$part->assign("ITEM", $dir);
				$part->parse("module.itemlist.item");
			} else {
				$this->number ++;
				$this->dirIndex[$this->number] = $dirData['dirpath'];
				$part->assign("NUMBER", $this->number);
				$part->assign("ITEMCONTAINER", $dir);
				$part->assign("SUBITEMS", $this->genList($size, false));
				$part->parse("module.itemlist.subitems");
			}
			$this->cache[$this->number] = $dir;
		}
		if($toplevel) {
			$part->parse("module.toplevelending");
		}

		$part->parse("module.itemlist");
		$_SESSION['filebrowserCache'] = $this->cache;
		return $part->parseModule();
	}

	function dirlist(RecursiveDirectoryIterator $it, $maxDepth = 2, $depth = 0)
    {	
		$parentPath = $it->getPath();
		$result = array();
        foreach ($it as $v) {
			if(count($this->regexFilters) == 0 or $this->filter($v)){ 
			if(!$this->showHidden) {
				$pathinfo = pathinfo($v->getFileName());
				if(substr($pathinfo['basename'], 0, 1) == '.') {
					continue;
				}
			}
            if ($v->isDir() and $v->getFileName() != "." and $v->getFileName() != "..") {
				$newPath = $v->getPathname();
				if($depth < $maxDepth) {
					if(!is_readable($newPath)) {
						continue;
					}
					try{
		                $result[$v->getFileName()]['subdirs'] = $this->dirlist(new RecursiveDirectoryIterator($newPath), $maxDepth, $depth + 1);
	                	$result[$v->getFileName()]['dirpath'] = $newPath;
					} catch (Exception $ex){
						continue;
					}
					
				} else {
	                $result[$v->getFileName()]['dirpath'] = $newPath;
	                $result[$v->getFileName()]['subdirs'] = False;
				}
            } else if ($v->getFileName() != "."&& $v->getFileName() != ".."){
				if($this->listFiles){
	                $result[$v->getFileName()] = "file";
				}
			}
        }
		}
		return $result;
    } 

	public function dirlist2 ($dir, $maxLevel = 2, $currentLevel = 0) {
		$tree = array();
		$dirs = array(array($dir, &$tree));
		$stop = false;		

		for($i = 0; $i < count($dirs) && !$stop; ++$i)
		{
			$d =& $dirs[$i][0];
			$tier =& $dirs[$i][1];
			$currentLevel++;
		
			for($d->rewind(); $d->valid(); $d->next())
			{
				if ($d->isDir())
				{
					$tier[$d->getFilename()] = array();
					$dirs[] = array($d->getChildren(), &$tier[$d->getFilename()]);
				}
				else
				{
					$tier[$d->getFilename()] = $d->getSize();
				}
			}
			if($currentLevel > $maxLevel){
				$stop = true;
			}
		}
		
		return $tree;
	}

	public function filter($v){
		if(is_file($v)){
		foreach($this->regexFilters as $filter){ 
			if(preg_match($filter, $v)){
				return true;
			}
		}
		} else {
			return true;
		}
		return false;
	}
	
	public function addFilter($regex){ 
		$this->regexFilters[] = $regex;
	}
	
	public function getFlattenFileList($list, &$retval = array()) {
		foreach($list as $key => $value){
			if($value == "file"){
				$retval[] = $key;
			} else if (is_array($key)){
				$this->getFlattenFileList($key, &$retval);
			} else if (is_array($value)){
				$this->getFlattenFileList($value, &$retval);
			}

		}
		return $retval;
	}
}
?>
