<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 13-12-07
 * date modified		: $Id$
 */

class Group {
	private $id;
	private $name;
	private $tempPermissions;
	private $parentUserId;

	public function __construct($id = false){
		$this->id = $id;
		if($id){
			$this->getFromDatabase();
		}
		$this->tempPermissions = array();
	}

	private function getFromDatabase(){
		global $mydb;
		list($record) = $mydb->getRecordsArray(UserManager::$prefix . "groups", "groupId", $this->id);
		$this->id = $record['groupId'];
		$this->name = $record['name'];
		$this->parentUserId = $record['parentUserId'];
	}

	public function getId(){
		return $this->id;
	}

	public function newGroup($name, $permissions, $parentUserId){
		$this->name = $name;
		$this->tempPermissions = $permissions;
		$this->parentUserId = $parentUserId;
	}

	public function getTemplateData() {
		$data['groupId'] = $this->id;
		$data['name'] = $this->name;
		$data['parentUserId'] = $this->parentUserId;
		return $data;
	}

	public function save(){
		if(!$this->id){
			return $this->add();
		} else {
			return $this->update();
		}
	}

	private function add(){
		global $mydb;
		$data = $this->getTemplateData();
		$id = $mydb->insertRecord($data, UserManager::$prefix . "groups");
		$this->id = $id;

		foreach($this->tempPermissions as $perm){
			$this->savePermission($perm);
		}
		$this->tempPermissions = array();
	}
	private function savePermission($perm) {
		global $mydb;
		$data = $perm->getTemplateData();
		$data["groupId"] = $this->id;
		$id = $mydb->replaceRecord($data, UserManager::$prefix . "group2permissions");
	}

	private function update(){
		global $mydb;
		$data = $this->getTemplateData();
		$mydb->updateRecord($data, UserManager::$prefix . "groups", "groupId", $this->id);
		$mydb->deleteRecord(UserManager::$prefix . "group2permissions", "groupId", $this->id);
		foreach($this->tempPermissions as $perm){
			$data = $perm->getTemplateData();
			$data["groupId"] = $this->id;
			$id = $mydb->insertRecord($data, UserManager::$prefix . "group2permissions");
		}
		$this->tempPermissions = array();
	}

	public function delete(){
		global $mydb;
		$mydb->deleteRecord(UserManager::$prefix . "groups", "groupId", $this->id);
		$mydb->deleteRecord(UserManager::$prefix . "group2permissions", "groupId", $this->id);
		$mydb->deleteRecord(UserManager::$prefix . "group2settings", "groupId", $this->id);
	}

	public function getSetting($identifier){
		foreach ($this->getAllSettings() as $setting){
			if($identifier == $setting->getIdentificationString()){
				return $setting;
			}
		}
	}

	public function saveSetting($setting){
		if($setting->isChanged()){
			global $mydb;
			$query = "DELETE FROM um_group2settings WHERE groupId = '" .$this->id. "' AND categoryId = '".$setting->getCategoryId(). "' AND id = '".$setting->getId()."'";
			$mydb->executeQuery($query);
			$data = $setting->getTemplateData();
			$data['groupId'] = $this->id;
			$mydb->insertRecord($data, UserManager::$prefix . "group2settings");
		}
	}

	public function getAllSettingsForCategory($categoryId){
		$settings = $this->getDefaultSettingsForCategory($categoryId);
		return $this->mySettings($settings);
	}

	public function getAllSettings(){
		$settings = $this->getDefaultSettings();
		return $this->mySettings($settings);
	}
	private function mySettings($settings) {
		global $mydb;
		$records = $mydb->getRecordsArray(UserManager::$prefix . "group2settings", "groupId", $this->id);
		foreach ($records as $row){
			foreach($settings as $setting){
				if($setting->getCategoryId() == $row['categoryId'] && $setting->getId() == $row['id']){
					$setting->setValue($row['value']);
					$setting->setPreviousValue($row['value']);
				}
			}
		}
		return $settings;
	}

	private function getDefaultSettingsForCategory($categoryId){
		$category = new Category($categoryId);
		$settings = $category->getAllSettings();
		if(count($settings)) {
			return $settings;
		}
		return array();
	}
	private function getDefaultSettings(){
		$settings = array();
		foreach ($this->getAllCategories() as $category){
#echo $category->getCategoryId()."<br>";
			$result = array_merge($category->getAllSettings(), $settings);
			$settings = $result;
		}
		return $settings;
	}
	
	public function getAllCategories(){
		$categories = array();
		$permissions = $this->getPermissions();
		$categoryManager = new CategoryManager();
		$categoryManager->setStartLevel(0);
		$categoryManager->showHidden(true);
		$categoryManager->clearCache();
		$categoryManager->setExpandLevel(999999999);
		
		$allCategories = $categoryManager->getSelectedCategoryTree();
		foreach ($allCategories as $cat){
			if($cat->isPublic()){
				$categories[$cat->getCategoryId()] = $cat;
			} else {
				foreach ($permissions as $perm){
					if($perm->getCategoryId() == $cat->getCategoryId() && $perm->getValue()){
						$categories[$cat->getCategoryId()] = $cat;
					}
				}
			}
		}
		return $categories;
	}

	public function getPermissionsForCategory($categoryId){
		global $mydb;
		$categoryManager = new CategoryManager();
		$allPermissions = $categoryManager->getAllPermissionsForCategory($categoryId);
		$permissions = array();
		//$records = $mydb->getRecordsArray(UserManager::$prefix . "group2permissions", "groupId", $this->id);
		$query = "SELECT * FROM um_group2permissions WHERE groupId = $this->id AND categoryId = $categoryId";
		$records = $mydb->convertRecordsToArray($mydb->executeQuery($query));
		foreach ($records as $row){
			$perm = new Permission($row['categoryId'], $row['name'], $row['value']);
			if(isset($allPermissions[$perm->getIdentificationString()])){
				$permissions[$perm->getIdentificationString()] = $perm;
			}
		}
		return $permissions;
	}


	public function getPermissions(){
		global $mydb;
		$categoryManager = new CategoryManager();
//		$categoryManager->clearCache();
		$allPermissions = $categoryManager->getAllPermissions();
		$permissions = array();
		$records = $mydb->getRecordsArray(UserManager::$prefix . "group2permissions", "groupId", $this->id);
		foreach ($records as $row){
			$perm = new Permission($row['categoryId'], $row['name'], $row['value']);
			if(isset($allPermissions[$perm->getIdentificationString()])){
				$permissions[$perm->getIdentificationString()] = $perm;
			}
		}
		return $permissions;
	}

	public function setPermission($categoryId, $name, $value){
		global $mydb;
		$perm = new Permission($categoryId, $name, $value);
		$this->savePermission($perm);
	}
	public function isDeletable(){
		global $mydb;
		$record1 = $mydb->getRecordsArray(UserManager::$prefix . "users", "groupId", $this->id);
		return !(count($record1) > 0);
	}
}
?>
