<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 04-10-07
 * date modified		: $Id: LanguageDependentField.class.php 168 2007-10-24 15:23:26Z erik $
 */
class LanguageDependentField extends Field {

	private $values;
	private $language;
	public $error = False;
	
	public function __construct($fieldName, $defaultValue, $condition, $languageDependent, $value, $type, $preProcessFunctions=array()){
		parent::__construct($fieldName, $defaultValue, $condition,  $languageDependent, $type);
		$this->values[DEFAULT_LANGUAGE] = $value;
		$this->language = DEFAULT_LANGUAGE;
	}
	
	public function read(){
		if(isset($_REQUEST[$this->fieldName])) {
			global $available_languages;
			foreach($available_languages as $language => $languageName) {
				if(isset($_REQUEST[$this->fieldName][$language])){
					$v = $_REQUEST[$this->fieldName][$language];
					foreach($this->preProcessFunctions as $func) {
						$v = $func($v);
					}
					$this->values[$language] =$v;
				}
			}
			$this->validate();
		}
	}

	public function validate(){
		$valid = true;
		if($this->condition) {
			# check only for default language
			$valid = (preg_match($this->condition, $this->values[DEFAULT_LANGUAGE]));
			$this->error = ($valid ? False : True);
		}
	}

	public function getValues(){
		return $this->values;
	}

	public function getValue(){
		if(isset($this->values[$this->language])){
			return stripslashes($this->values[$this->language]);
		} else {
			return "";
		}
	}

	public function setValues($values){
		global $available_languages;

		foreach($available_languages as $language => $languageName) {
			if(isset($values[$language])){
				$this->values[$language] = stripslashes($values[$language]);
			}
		}
	}
	public function setValue($value){
		if(is_array($value)) {
			$this->setValues($value);
		} else {
			$this->values[$this->language] = $value;
		}
	}

	public function getValueByLanguage($wantedLanguage){
		$value = $this->getValue(DEFAULT_LANGUAGE);
/*
		if(isset($this->values[$wantedLanguage])){
			$value = $this->values[$wantedLanguage];
		} else if (isset($this->values[$this->language])){
			$value = $this->values[$this->language];
		}
*/
		if(isset($this->values[$wantedLanguage]) && $this->values[$wantedLanguage] != '') {
			$value = $this->values[$wantedLanguage];
		}
		return $value;
	}

	public function assign($repKey, $repValue) {
		$oldValues = $this->getValues();
		$newValues = array();
		$rep = "{REPLACE." . $repKey . "}";
		foreach($oldValues as $key => $value){
				$newValues[$key] = str_replace($rep, $repValue, $value);
		}
		$this->setValues($newValues);
	}

	public function toString(){
		return "Fieldname: " . $this->fieldName . ", Value: " . $this->getValue();
	}
}
?>
