<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 04-10-07
 * date modified		: $Id: PairedField.class.php 165 2007-10-24 14:38:00Z erik $
 */

class ListField extends Field {
	private $value = array();
	public $error = False;
	private $listWithConfig;
	
	public function __construct($fieldName, $defaultValue, $condition, $languageDependent, $value, $type, $listWithConfig){
		parent::__construct($fieldName, $defaultValue, $condition, $languageDependent, $type);
		$this->value = $value;
		$this->listWithConfig = $listWithConfig;
	}
	
	public function read(){
		if(isset($_REQUEST["list_".$this->getFieldName()]) && is_array($_REQUEST["list_".$this->getFieldName()])) {
			$this->value = $_REQUEST["list_".$this->getFieldName()];
		} else {
			$this->value = array();
		}
	}

	public function validate(){
		//FIXME maybe count the number of selected pairs...
	}

	public function getValue(){
		return $this->value;
	}

	public function setValue($value){
		if(is_array($value)){
			$this->value = $value;
		} else {
			$this->value = array();
		}	
	}
	
	public function toString(){
		return "Fieldname: " . $this->fieldName . ", Value: " . $this->getValue();
	}

	public function getContentItems(){
		$contentManager = new ContentManager(False, $this->listWithConfig, false);
		$contentManager->setSelectFromAllCategories(true);
		return $contentManager->getContentItems();
	}

	public function getListWithConfig(){
		return $this->listWithConfig;
	}

	public function getListedItems() {
		$listed = array();
		$items = $this->getContentItems();
		foreach($items as $item) {
			if($this->isListed($item)) {
				$listed[] = $item;
			}
		}
		return $listed;
	}

	public function isListed($contentItem){
		if(count($this->value) == 0){
			return false;
		}
		foreach($this->value as $value){
			if($value == $contentItem->getItemId()){
				return true;
			}
		}
		return false;
	}
}
?>
