<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 04-10-07
 * date modified		: $Id: NormalField.class.php 165 2007-10-24 14:38:00Z erik $
 */

class NormalField extends Field {
	private $value;
	public $error = False;
	
	public function __construct($fieldName, $defaultValue, $condition, $languageDependent, $value, $type, $preProcessFunctions=array()){
		parent::__construct($fieldName, $defaultValue, $condition, $languageDependent, $type, $preProcessFunctions);
		if($value) {
			$this->value = $value;
		}
	}
	
	public function read(){
		if(isset($_REQUEST[$this->fieldName]) && !is_array($_REQUEST[$this->fieldName])) {
			$this->value = $_REQUEST[$this->fieldName];
			foreach($this->preProcessFunctions as $func) {
				$this->value = $func($this->value);
			}
			$this->validate();
		} else if ($this->type=="checkbox") {
			//kan een checkbox zijn die uitgechecked is.
			$this->value = '';
		}
	}

	public function validate(){
		if($this->condition) {
			$valid = (preg_match($this->condition, $this->value));
			$this->error = !$valid;
		} else {
			$this->error=false;
		}
	}

	public function getValue(){
		return stripslashes($this->value);
	}

	public function setCondition($condition){
		$this->condition = $condition;
	}
	public function setValue($value){
		$this->value = $value;
	}
	
	public function toString(){
		return "Fieldname: " . $this->fieldName . ", Value: " . $this->getValue();
	}
}

?>
