<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 18-10-07
 * date modified		: $Id$
 */

class Pdf {
	private $textData;
	private $pdf;
	private $pageOpen;
	private $headerHeight;
	private $footerHeight;
	private $pageWidth;
	private $pageHeight;

	private $margeTop;
	private $margeBottom;
	private $margeLeft;
	private $margeRight;

	private $font;
	private $fontId;
	private $fontType;
	private $fontSize;
	private $currentY = 0;
	private $fonts = array();
	
	public function __construct($textData, $saveFile=False){
		global $pdfConf;
		$this->pageOpen = false;
		$this->textData = $textData;
		
		//TODO config voor wegschrijven naar schijf
		
		$author 				= $pdfConf['author'];
		$title 					= $pdfConf['title'];
		$creator 				= $pdfConf['creator'];
		$this->fontType 		= $pdfConf['fontType'];
		$this->fontSize 		= $pdfConf['fontSize'];
		$this->pageWidth 		= $pdfConf['pageWidth'];
		$this->pageHeight 		= $pdfConf['pageHeight'];
		if(isset($pdfConf['headerHeight'])){
			$this->headerHeight 	= $pdfConf['headerHeight'];
		} else {
			$this->headerHeight 	= 0;
		}
		if(isset($pdfConf['footerHeight'])){
			$this->footerHeight 	= $pdfConf['footerHeight'];
		} else {
			$this->footerHeight 	= 0;
		}
		$this->margeTop 		= $pdfConf['margeTop'];
		$this->margeBottom 		= $pdfConf['margeBottom'];
		$this->margeLeft 		= $pdfConf['margeLeft'];
		$this->margeRight 		= $pdfConf['margeRight'];
		//Open Pdf
		$this->pdf = new PDFlib();
		$this->pdf->begin_document("","");
		//Set pdf info
		$this->pdf->set_info("Author", $author);
		$this->pdf->set_info("Title", $title);
		$this->pdf->set_info("Creator", $creator);
	
		//set font
		$this->fonts['Comic Sans MS'] = "Comic";
		
		$this->pdf->set_parameter("FontOutline", "Arial=/usr/local/share/pdflib/fonts/arial.ttf");
		$this->pdf->set_parameter("FontOutline", "Comic=".BASEPATH."dcms/fonts/comic.ttf");
    	$this->font = $this->pdf->load_font($this->fontType, "winansi", "");
		//start new page
		$this->newPage();
		$this->writeMain();
		$this->getDocument($saveFile);
	}

	public function newPage(){
		if($this->pageOpen){
			#$this->writeFooter(); # TODO if first time
			$this->writeFollowUpFooter();
			$this->pdf->end_page_ext("");
		}	
		$this->pdf->begin_page_ext($this->pageWidth, $this->pageHeight, "");
		if($this->pageOpen){
			$this->writeFollowUpHeader();
		} else {
			$this->writeHeader();
		}
		$this->pageOpen = true;
	}

	public function getDocument($saveFile=False){
		global $pdfConf;
		$this->writeFooter();
		if($this->pageOpen){
			$this->pdf->end_page_ext("");
			$this->pageOpen = false;
		}
		$this->pdf->end_document("");

	    $buf = $this->pdf->get_buffer();	
	    $len = strlen($buf);

		if($saveFile) {
			$path = BASEPATH . UPLOADS_DIR . $saveFile .".pdf";
			$f = fopen($path, 'w');
			fwrite($f, $buf);
			fclose($f);
		} else {
		    header("Content-type: application/pdf");
	    	header("Content-Length: $len");
			$file = $pdfConf['title'];
			if(isset($pdfConf['fileTitle'])) {
				$file = $pdfConf['fileTitle'];
			}
		    header("content-disposition: inline; filename=".$file.".pdf");
		    print $buf;
		}
	}	

	private function getText($key){
		if(isset($this->textData[$key])){
			return $this->textData[$key];
		} else {
			return "ERR_KEY_NOT_EXIST:$key";
		}
	}

	public function getCurrentY() {
		return $this->currentY;
	}

	private function writeFollowUpHeader(){
		global $pdfConf;
		if(isset($pdfConf['followupHeader']) && $pdfConf['followupHeader'] != "" && file_exists($pdfConf['followupHeader']) && !is_dir($pdfConf['followupHeader'])){
#			echo __FUNCTION__;	exit;
			include_once($pdfConf['followupHeader']);
		}
	}

	private function writeFollowUpFooter(){
		global $pdfConf;
		if(isset($pdfConf['followupFooter']) && $pdfConf['followupFooter'] != "" && file_exists($pdfConf['followupFooter']) && !is_dir($pdfConf['followupFooter'])){
#			echo __FUNCTION__;	exit;
			include_once($pdfConf['followupFooter']);
		}

	}
	
	private function writeMain(){
		global $pdfConf;
		if(isset($pdfConf['main']) && $pdfConf['main'] != "" && file_exists($pdfConf['main'])  && !is_dir($pdfConf['main'])){
			include_once($pdfConf['main']);
		}
	}

	private function writeHeader(){
		global $pdfConf;
		if(isset($pdfConf['header']) && $pdfConf['header'] != "" && file_exists($pdfConf['header']) && !is_dir($pdfConf['header'])){
			include_once($pdfConf['header']);
		}
	}

	private function writeFooter(){
		global $pdfConf;
		if(isset($pdfConf['footer']) && $pdfConf['footer'] != "" && file_exists($pdfConf['footer']) && !is_dir($pdfConf['footer'])){
			echo __FUNCTION__;	exit;
			include_once($pdfConf['footer']);
		}

	}

	private function drawLine($x1,$y1, $x2,  $y2) {
		$this->pdf->moveto($x1, $y1);
		$this->pdf->lineto($x2, $y2);
		$this->pdf->stroke();
	}

	private function drawRectangle($x, $y, $width, $height){
		$this->drawLine($x			, $y			, $x + $width	, $y			);
		$this->drawLine($x			, $y			, $x			, $y + $height	);
		$this->drawLine($x + $width	, $y			, $x + $width	, $y + $height	);
		$this->drawLine($x			, $y +$height	, $x + $width	, $y + $height	);
	}

	private function writeLineRight ($text, $y){
		$x = $this->pageWidth - $this->margeRight - $this->getStringWidth($text);
		$this->writeLine($text, $x, $y);
	}
	
	private function writeLineLeft ($text, $y){
		$x = $this->margeLeft;
		$this->writeLine($text, $x, $y);
	}

	private function writeLineAtCurrentY ($text, $x = false){
		if(!$x){
			$x = $this->margeLeft;
		}
		$this->writeLine($text, $x, $this->currentY);
	}

	private function writeLine($text, $x, $y, $angle = false) {
		//TODO en als de write line het einde van de pagina bereikt moet er een nieuwe pagina toegevoegd worden.
		$this->pdf->setfont($this->font, $this->fontSize);
		$this->currentY = $y;
		if(is_array($text) && count($text)){
			if($angle == false){
				$this->pdf->rotate(0);
			} else {
				$this->pdf->rotate(90);
			}
	    	$this->pdf->set_text_pos($x, $y);
			$this->pdf->show(utf8_decode($text[0]));
			$this->currentY -= $this->fontSize;
		    foreach($text as $key => $line){
				$line = utf8_decode($line);
				if($key != 0 && $this->currentY < ($this->margeBottom + $this->footerHeight) && !$angle){
					// FIXME HEADER + FOOTER HEIGHT!
					$this->newPage();
					$this->pdf->setfont($this->font, $this->fontSize);
					$this->currentY = $this->pageHeight - $this->margeTop - $this->headerHeight;
	    			$this->pdf->set_text_pos($x, $this->currentY);
					$this->pdf->show($line);
				} else if ($key != 0){
					$this->pdf->continue_text($line);
				}
				$this->currentY -= $this->fontSize;
			}
		} else if(is_string($text)){
			$text = utf8_decode($text);
			$this->pdf->set_text_pos($x, $y);
			$this->pdf->show($text);
			$this->currentY -= $this->fontSize;
		} else {
			#echo "Empty array/string";
		}
		//reset old orientation
		if($angle == true){
			$this->pdf->rotate(-1 * $angle);
		}
	}

	private function getLineHeight($lines = 1){
		return $this->fontSize * $lines;
	}

	private function setFontSize ($fontSize){
		$this->fontSize = $fontSize;
	}

	private function setFontType ($fontType){
		$this->fontType = $fontType;
		if(array_key_exists($fontType, $this->fonts)){
	    	$this->font = $this->pdf->load_font($this->fonts[$fontType], "winansi", "");
		} else {
	    	$this->font = $this->pdf->load_font("Arial", "winansi", "");
		}
	}

	private function setFontColor($hexcolor){
		$color=$this->rgb2cmyk($this->hex2rgb($hexcolor));
		$this->pdf->setcolor("both", "cmyk", $color['c'], $color['m'], $color['y'], $color['k']);
	}

	private function hex2rgb($hex) {
		$color = str_replace('#','',$hex);
		$rgb = array('r' => hexdec(substr($color,0,2)),
               'g' => hexdec(substr($color,2,2)),
               'b' => hexdec(substr($color,4,2)));
		return $rgb;
	}

	private function rgb2cmyk($var1,$g=0,$b=0) {
	   if(is_array($var1)) {
	      $r = $var1['r'];
    	  $g = $var1['g'];
	      $b = $var1['b'];
	   }
	   else $r=$var1;
		   $cyan    = 255 - $r;
		   $magenta = 255 - $g;
		   $yellow  = 255 - $b;
		   $black   = min($cyan, $magenta, $yellow);
			$divider = 255 - $black;
			if($divider) {
			   $cyan    = @(($cyan    - $black) / ($divider)) * 255;
			   $magenta = @(($magenta - $black) / ($divider)) * 255;
			   $yellow  = @(($yellow  - $black) / ($divider)) * 255;
			}
	   return array('c' => $cyan / 255,
                'm' => $magenta / 255,
                'y' => $yellow / 255,
                'k' => $black / 255);
	}

	private function splitTextOnNewline($text){
		return split("\r\n", $text);
	}
	private function splitTextForWidth($text, $width, $takeNewlinesIntoAccount = false){
		//First determine the length
		$length = 1;
		$stop = false;
		while (!$stop) {
			$part = substr($text, 0, $length);
			if($this->getStringWidth($part) > $width or strlen($text) == $length or $this->getStringWidth($part) == 0){;
				$stop = true;
			}
			$length ++;
		}

		// Then split on new lines (if needed)
		$splittedText = array();
		if($takeNewlinesIntoAccount){
			foreach( $this->splitTextOnNewline($text) as $x){
				$splittedText[] = $x;
			}
		} else {
			$splittedText[] = $text;
		}

		$texts = array();
		return $texts;
		foreach($splittedText as $textLeft){
			if(strlen($textLeft) < $length) {
				$texts[] = $textLeft;
			} else {
				while (strlen($textLeft) >= $length){
					$testpart = trim(substr($textLeft, 0, $length));
					$spacePos = strrpos($testpart, " ") + 1;
					if($spacePos){
						$part = trim(substr($textLeft, 0, $spacePos));
						$textLeft = substr($textLeft, $spacePos, strlen($textLeft));
					} else {
						$part = trim(substr($textLeft, 0, $length));
						$textLeft = substr($textLeft, $length, strlen($textLeft));
					}
					$texts[] = $part;
				}
				$texts[] = $textLeft;
			}
		}
	
		return $texts;
	}	

	private function getStringWidth($text){
		$width = -1;
		if(is_array($text)){
			$maxwidth = -1;
			foreach ($text as $line){
				$thiswidth = $this->pdf->stringwidth($line, $this->font, $this->fontSize);
				if($maxwidth < $thiswidth){
					$maxwidth = $thiswidth;
				}
			}
			$width = $maxwidth;
		} else {
			$width = $this->pdf->stringwidth($text, $this->font, $this->fontSize);
		}
		return $width;
	}

	private function addImage ($location, $x, $y, $width = false, $height = false){
		$image = $this->pdf->load_image("auto", $location, "");
		if ($image) {
			$opt = '';
			if($width or $height){
				$opt = "boxsize={" . $width . " " . $height . "} " . "fitmethod=meet";
				//echo $opt. "<BR>";
			}
			$this->pdf->fit_image($image, $x,$y, $opt);
			$this->pdf->close_image($image);
		} else {
			//echo "error";
		}
	}
}
?>
