<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 13-12-07
 * date modified		: $Id$
 */


class Permission {
	private $categoryId;
	private $name;
	private $value;

	public function __construct($categoryId, $name, $value){
		$this->name = $name;
		$this->categoryId = $categoryId;
		$this->value = $value;
	}
	
	public function toString(){
		return "CategoryId" . $this->categoryId . ", Name: " .$this->name.", value (yes or no): ". $this->value;
	}

	public function getTemplateData() {
		$category = new Category($this->categoryId);
		$data['categoryId'] = $category->getCategoryId();
		$data['categoryName'] = $category->getName();
		$data['name'] = $this->name;
		$data['value'] = $this->value;
		$data['identificationString'] = $this->getIdentificationString();
		if($this->value){
			$data['valueSelected'] = "SELECTED";
			$data['valueChecked'] = "CHECKED";
		} else {
			$data['valueSelected'] = "";
			$data['valueChecked'] = "";
		}
		return $data;
	}

	public function setValue($value){
		$this->value = $value;
	}
		
	public function getCategoryId(){
		return $this->categoryId;
	}

	public function getName(){
		return $this->name;
	}
	
	public function getValue(){
		return $this->value;
	}

	public function getIdentificationString(){
		return $this->categoryId . ":". $this->name;
	}
}
?>
