<?php
/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 13-12-07
 * date modified		: $Id$
 */

class Range {
	private $rangeId;
	private $a;
	private $b;
	private $c;
	private $d;
	private $priority;
	private $user;

	public function __construct($rangeId = false){
		$this->rangeId = $rangeId;
		if($rangeId){
			$this->getFromDatabase();
		}
	}

	public function newRange($a, $b, $c, $d, $priority, $userId){
		$this->rangeId = false;
		$this->a = $a;
		$this->b = $b;
		$this->c = $c;
		$this->d = $d;
		$this->priority = $priority;
		$this->user = new User($userId);
	}

	private function getFromDatabase(){
		global $mydb;
		list($record) = $mydb->getRecordsArray(UserManager::$prefix . "ranges", "rangeId", $this->rangeId);
		$this->rangeId = $record['rangeId'];
		$this->a = $record['a'];
		$this->b = $record['b'];
		$this->c = $record['c'];
		$this->d = $record['d'];
		$this->priority = $record['priority'];
		$this->user = new User($record['userId']);
	}

	public function getTemplateData() {
		$data['rangeId'] = $this->rangeId;
		$data['a'] = $this->a;
		$data['b'] = $this->b;
		$data['c'] = $this->c;
		$data['d'] = $this->d;
		$data['priority'] = $this->priority;
		$data['userId'] = $this->user->getId();
		return $data;
	}

	public function save(){
		if(!$this->rangeId){
			return $this->add();
		} else {
			return $this->update();
		}
	}

	public function delete(){
		global $mydb;
		$mydb->deleteRecord(UserManager::$prefix . "ranges", "rangeId", $this->rangeId);
	}

	private function add(){
		global $mydb;
		$data = $this->getTemplateData();
		$id = $mydb->insertRecord($data, UserManager::$prefix . "ranges");
		$this->rangeId = $id;
	}

	private function update(){
		global $mydb, $available_languages, $contentConf;
		$data = $this->getTemplateData();
		$mydb->updateRecord($data, UserManager::$prefix . "ranges", "rangeId", $this->rangeId);
	}

	public function getUser(){
		return $this->user;
	}
	
	public function setA($a){ $this->a = $a; }
	public function setB($b){ $this->b = $b; }
	public function setC($c){ $this->c = $c; }
	public function setD($d){ $this->d = $d; }
	public function setUser($user){ $this->user = $user; }
	
	public function match($ip){
		$splittedIp = split("\.",$ip);
		$a = $splittedIp[0];
		$b = $splittedIp[1];
		$c = $splittedIp[2];
		$d = $splittedIp[3];
		if (($this->a == '*' and $this->b == '*' and $this->c == '*' and $this->d == '*') and USERENVIROMENT == False) {
			# guest network and admin so no login
			return False;
		}
		
		return ($this->matchPart($this->a, $a) and $this->matchPart($this->b, $b) and $this->matchPart($this->c, $c) and	$this->matchPart($this->d, $d));
	}

	public function matchPart($rangePart, $ipPart){
		return ($rangePart == "*" or $ipPart == $rangePart);
	}

	public function isDeletable(){
		return true;
	}
}
?>
