<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 04-10-07
 * date modified		: $Id: NormalField.class.php 165 2007-10-24 14:38:00Z erik $
 */

class SelectField extends Field {
	private $value;
	private $selectOptions = array();
	public $error = False;
	
	public function __construct($fieldName, $defaultValue, $condition, $languageDependent, $value, $type, $selectOptions=False, $selectContentConfig=False){
		parent::__construct($fieldName, $defaultValue, $condition, $languageDependent, $type, array());
		if($value) {
			$this->value = $value;
		}
		# $selectOptions=False, $selectContentConfig=False)
		if(is_array($selectOptions)) {
			$this->selectOptions = $selectOptions;
		} else if ($selectContentConfig){
			$this->createSelectOptionsFromContent($selectContentConfig);
		}
	}
	public function createSelectOptionsFromContent($selectContentConfig){
		$contentConfigFile = $selectContentConfig['contentConfig'];
		$contentCategoryId = $selectContentConfig['contentCategoryId'];
		$cm = new ContentManager(False, $contentConfigFile);
		foreach($items = $cm->getContentItems() as $item) {
			$k = $item->getItemId();
			$this->selectOptions[$k] = $item->getValue($cm->getListtitle());
		}
	}
	
	public function getSelectOptions(){
		# TODO een selected veld!
		$returnOptions = array();
		foreach($this->selectOptions as $k => $v) {
			$ro = array();
			$ro['optionKey'] = $k;
			$ro['optionValue'] = $v;
			$ro['optionSelected'] = $k == $this->value ? 'selected' : '';
			$returnOptions[] = $ro;
		}
		return $returnOptions;
	}
	public function read(){
		if(isset($_REQUEST[$this->fieldName]) && !is_array($_REQUEST[$this->fieldName])) {
			$this->value = $_REQUEST[$this->fieldName];
			foreach($this->preProcessFunctions as $func) {
				$this->value = $func($this->value);
			}
			$this->validate();
		}
	}

	public function validate(){
		if($this->condition) {
			$valid = (preg_match($this->condition, $this->value));
			$this->error = !$valid;
		} else {
			$this->error=false;
		}
	}

	public function getValue(){
		return stripslashes($this->value);
	}

	public function setCondition($condition){
		$this->condition = $condition;
	}
	public function setValue($value){
		$this->value = $value;
	}
	
	public function toString(){
		return "Fieldname: " . $this->fieldName . ", Value: " . $this->getValue();
	}
}

?>
