<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 03-01-08
 * date modified		: $Id$
 */

class TemplateProxy {
	
	private $template;
	private $nixBehaviour;
	private $userManager;
	private $debug;
	public $isDebug;
	public $filename;
	private $moduleParsed;
	private $userEnviroment;
	private $categoryId;
	
	public function __construct($layout){
		$this->template = new XTemplate($layout);
		$this->userManager = new UserManager();
		$this->nixBehaviour = false;
		#$this->nixBehaviour = true;
		if(defined('USERMANAGEMENT') and defined('USERENVIROMENT')){
			$this->userEnviroment = USERENVIROMENT;
		} else {
			$this->userEnviroment = false;
		}
		$this->isDebug = false;
		#$this->isDebug = true;
		
		$this->moduleParsed = false;
		$this->filename = $this->template->filename;
		translate($this->template);
	}

	public function setCategoryId($categoryId) {
		$this->categoryId = $categoryId;
	}

	public function reset($bname) {
		$this->template->reset($bname);
	}

	public function assign ($name, $val = '', $reset_array = true, $categoryId = "", $permission = "") {
		if($this->hasPermission($this->categoryId, $permission)){
			$this->debug("Assign <font color='green'>allowed</font> with name '$name' category '$this->categoryId' permission '$permission'.");
			return $this->template->assign($name, $val, $reset_array);
		} else {
			$this->debug("Assign <font color='red'>disallowed</font> with name '$name' category '$this->categoryId' permission '$permission'.");
		}
	}

	public function parseModule($permission = ""){
		if(!$this->moduleParsed){
			$this->moduleParsed = true;
			if($this->hasPermission($this->categoryId, $permission)){
				$this->debug("ParseModule <font color='green'>allowed</font> with category '".$this->categoryId."' permission '$permission'.");
				$this->template->parse('module');
				return $this->template->text('module');
			} else {
				$this->debug("ParseModule <font color='red'>disallowed</font> with category '".$this->categoryId."' permission '$permission'.");
				//RETURN AUTHENTICATION ERROR
				return "";
			}
		} else {
			$this->debug("ParseModule <font color='red'>already executed</font> with category '".$this->categoryId."' permission '$permission'.");
		}
	}

	public function parseCategory ($bname, $categoryId = "", $isPublic=False ) {
		static $cache = array();
		if(isset($cache[$categoryId])) {
			$perm = $cache[$categoryId];
		} else {
			$perm = $this->hasPermissionForCategory($categoryId, $isPublic);
			$cache[$categoryId] = $perm;
		}

		if($perm){
			$this->debug("ParseCategory <font color='green'>allowed</font> with name '$bname' category '$categoryId'.");
			$this->template->parse($bname);
			return True;
		} else {
			if($categoryId == $_SESSION['selectedcat']) {
				$_SESSION['selectedcat'] = 0;
				$GLOBALS['GHOSTPAGE']['module'] = '';
				$GLOBALS['GHOSTPAGE']['adminmodule'] = '';
				$GLOBALS['GHOSTPAGE']['template'] = '';
			}
			$this->debug("ParseCategory <font color='red'>disallowed</font> with name '$bname' category '$categoryId'.");
		}
		return False;
	}
	
	public function parse ($bname, $permission = "") {
	//	echo $bname . "<BR>";
		if($this->hasPermission($this->categoryId, $permission)){
			$this->debug("Parse <font color='green'>allowed</font> with name '$bname' category '".$this->categoryId."' permission '$permission'.");
			return $this->template->parse($bname);
		} else {
			$this->debug("Parse <font color='red'>disallowed</font> with name '$bname' category '".$this->categoryId."' permission '$permission'.");
		}
	}

	public function text ($bname = '', $categoryId = "", $permission = "") {
		if($this->hasPermission($this->categoryId, $permission)){
			$this->debug("Text <font color='green'>allowed</font> with name '$bname' category '$this->categoryId' permission '$permission'.");
			return $this->template->text($bname);
		} else {
			$this->template->reset($bname);
			$this->debug("Text <font color='red'>disallowed</font> with name '$bname' category '$this->categoryId' permission '$permission'.");
		}
	}

	public function hasPermissionForCategory($categoryId, $thisIsPublic=False ){
#$this->isDebug = True;
		if(!defined('USERMANAGEMENT') || !USERMANAGEMENT ){
			$this->debug("No user management enabled.");
			return true;
		}

		// Als windows behaviour en geen permissies nodig, dan sta alles toe
		if(!$this->nixBehaviour and ($categoryId == "")){
			$this->debug("Windows behaviour for category (categoryId = '').");
			return true;
		} else if($this->nixBehaviour and ($categoryId == "")){
			$this->debug("*nix behaviour for category ('$categoryId').");
			return false;
		}

		if($thisIsPublic === False) {
			$category = new Category($categoryId);
			$isPublic = $category->isPublic();
		} else {
			$isPublic = $thisIsPublic;
		}

		if($this->userEnviroment && $isPublic){
			$this->debug("Category '$categoryId' is public");
			return true;
		// Wel permissies, admin, logged on
		// 0,1,0
		} else if (!$isPublic && !$this->userEnviroment && !$this->userManager->isLoggedIn()) { 
			$this->debug("Category is not public, no user enviroment, no user logged on (FALSE).");
			return false;
		}
#		if($categoryId == 6) echo microtime(1)." 1d <br>";
		// Als er wel permissies nodig zijn, controlleer
		$user = $this->userManager->getLoggedInUser();
		if($user && $user->hasPermissionOnCategory($categoryId)){
			$this->debug("User has permission on category '$categoryId'");
#				if($categoryId == 6) echo microtime(1)." 1e <br>";
			return true;
		} else if (!$user && !$this->nixBehaviour) {
#				if($categoryId == 6) echo microtime(1)." 1f <br>";
			$this->debug("No user but windows behaviour is enabled (CategoryId: '$categoryId') (TRUE)");
			return true;
		} else {
#				if($categoryId == 6) echo microtime(1)." 1g <br>";
			$this->debug("myUser has no permission (CategoryId: '$categoryId') (FALSE)");
			return false;
		}
	}

	private function hasPermission($categoryId, $permission){
		if(!defined('USERMANAGEMENT') || !USERMANAGEMENT){
			$this->debug("No user management enabled.");
			return true;
		}
		// Als windows behaviour en geen permissies nodig, dan sta alles toe
		if(!$this->nixBehaviour and ($permission == "" or $this->categoryId == "")){
			$this->debug("Windows behaviour ('$this->categoryId', '$permission').");
			return true;
		} else if($this->nixBehaviour and ($permission == "" or $this->categoryId == "")){
			$this->debug("*nix behaviour. (CategoryId: '$this->categoryId', Permission: '$permission')");
			return false;
		}

		$category = new Category($categoryId);
		if($this->userEnviroment && $category->isPublic()){
			$this->debug("Category '$this->categoryId' is public");
			return true;
		//} else if (count($category->getPermissions()) && !$this->userEnviroment && !$this->userManager->isLoggedIn()) { 
		} else if (!$category->isPublic() && !$this->userEnviroment && !$this->userManager->isLoggedIn()) { 
			$this->debug("Category is not public, no user enviroment, no user logged on (FALSE).");
			return false;
		}
		// Als er wel permissies nodig zijn, controlleer
		$user = $this->userManager->getLoggedInUser();
		if($user && $user->hasPermission($this->categoryId, $permission)){
			$this->debug("User has permission '$permission'");
			return $user->hasPermission($this->categoryId, $permission);
		}
		$this->debug("Default return(CategoryId: '$categoryId') (FALSE)");
		return false;
	}

	public function debug($message){
		if($this->isDebug){
			echo "TemplateProxyDebug: " . $message;
			$user = $this->userManager->getLoggedInUser();
			if(is_object($user)) {
				echo " ('".$user->getName()."')<BR>";
			} else {
				echo "<br>\n";
			}
		}
	}

}
?>
