<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 27-12-07
 * date modified		: $Id$
 */

class Validator {
	private $fields;
	private $errors;	

	public function __construct($fields = array()){
		$this->fields = $fields;
		$this->errors = array();
	}

	public function isValid(){
		$allValid = true;
		foreach($this->fields as $key => $regex) {
			$valid = true;
			$valid = (isset($_REQUEST[$key]) and $this->thisValid($_REQUEST[$key], $regex));
			if(!$valid){
				$allValid = false;
				$this->errors[] = $key;
			}
		}
		return $allValid;
	}
	public function thisValid($value, $regex){
		return preg_match($regex, $value);
	}

	public function value($name){
		return $_REQUEST[$name];
	}

	public function generateMessages(){
		$errorMessage = "Some fields are incorrect ('";
		$errorMessage .= implode("', '", $this->errors);
		$errorMessage .= "').";
		$_SESSION['messages'][] = $errorMessage;
	}
}
?>
