<?
/*
 * Author           : Ivo Hunink
 * company          : DataCT
 * date created     : ?
 * date modified    :
 */

class Whois {
	private $errors = array();	
	
	public $topLevelDomains = array(
			'nl'=> array('compare_string'=>'.nl is free', 'server'=>'rwhois.domain-registry.nl', 'port' => 43, 'queryformat' => "is DOMAIN.TLD\r\n"),
			'eu'=> array('compare_string'=>'Status: AVAILABLE', 'server'=>'das.eu', 'port' => 4343, 'queryformat' => "get 1.0 DOMAIN\n"),
			'com' => array('compare_string'=>'No match', 'server'=>'whois.internic.net', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'net' => array('compare_string'=>'No match', 'server'=>'whois.internic.net', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'org' => array('compare_string'=>'NOT FOUND', 'server'=>'whois.opensrs.net', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'biz' => array('compare_string'=>'Not found', 'server'=>'whois.biz', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'info' => array('compare_string'=>'NOT FOUND', 'server'=>'whois.afilias.net', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'be' => array('compare_string'=>'FREE', 'server'=>'whois.dns.be', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'de' => array('compare_string'=>'free', 'server'=>'whois.denic.de', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'co.uk' => array('compare_string'=>'No match', 'server'=>'whois.nic.uk', 'port' => 43, 'queryformat' => "DOMAIN.TLD\r\n"),
		#	'org.uk' => array('compare_string'=>'No match', 'server'=>'whois.nic.uk', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'us' => array('compare_string'=>'Not found', 'server'=>'whois.nic.us', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'cn' => array('compare_string'=>'no matching', 'server'=>'whois.cnnic.net.cn', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'in' => array('compare_string'=>'NOT FOUND', 'server'=>'whois.inregistry.net', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'ca' => array('compare_string'=>'AVAIL', 'server'=>'whois.cira.ca', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'jp' => array('compare_string'=>'No match', 'server'=>'whois.jprs.jp', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'ws' => array('compare_string'=>'No match', 'server'=>'whois.website.ws', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'mobi' => array('compare_string'=>'NOT FOUND', 'server'=>'whois.dotmobiregistry.net', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'name' => array('compare_string'=>'No match', 'server'=>'whois.nic.name', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'nu' => array('compare_string'=>'NO MATCH', 'server'=>'whois.nic.nu', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"),
			'cc' => array('compare_string'=>'No match', 'server'=>'whois.nic.cc', 'port' => 43, 'queryformat' => "DOMAIN.TLD\n"));

	function aredomainWithExtensionsFree($domainname, $extensions=False){
		$result = array();
		if(!$extensions) {
			$extensions = array_keys($this->topLevelDomains);
		}
		$this->checkedDomains = array();
		foreach ($extensions as $extension){
			$this->checkedDomains[$extension] = $this->isDomainWithExtensionFree($domainname, $extension);
		}
		
		return $this->checkedDomains;
	}
	function getCheckedDomains() {
		return $this->checkedDomains;
	}

	function isDomainWithExtensionFree($domainname, $extension) {
		$tld = $this->topLevelDomains[$extension];
		$raw = $this->queryWhoisServer($domainname, $extension, $tld['server'], $tld['port'], $tld['queryformat']);
		if ($raw == false) {
			return false;
		}
		if (stristr($raw,$tld['compare_string'])) {
			return true;
		} else {
			return false;
		}
	}
	
	public function getAvailableTlds(){
		return $this->topLevelDomains;
	}
	
	public function getErrors() {
		return $this->errors;
	}

	public function hasErrors() {
		return count($this->errors>0);
	}	

	function queryWhoisServer($domain, $tld, $server, $port=43, $queryformat="DOMAIN.TLD\n") {
#		ini_set('default_socket_timeout', 1.5);
		if(!($ns = @fsockopen($server, $port,&$errno, &$errstr , 2.5))){
			$this->errors[] = "Can't connect to $server, $errstr";
			return false;
		}
#		stream_set_timeout($ns, 1.5);


#		$ns = curl_init('telnet://'.$server);
#		curl_setopt($ns, CURLOPT_PORT, $port);
#		curl_setopt($ns, CURLOPT_RETURNTRANSFER, TRUE);
#		curl_setopt($ns, CURLOPT_WRITEFUNCTION, 'writeRequest');
#		$status = curl_getinfo($ns);
#		echo $status;

		$query = str_replace('DOMAIN', $domain, $queryformat);
		$query = str_replace('TLD', $tld, $query);
		fputs($ns,$query);
		$rawoutput = "";
		while(!feof($ns)) {	
			$rawoutput = $rawoutput.fgets($ns,128);
		}
		fclose($ns);
		return $rawoutput; 
	}
}
?>
