<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT	
 * date created			: 19-12-09
 * date modified		: $Id$
 */

class CURL {
	private $_useragent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1';
	private $_url;
	private $_followlocation;
	private $_timeout;
	private $_maxRedirects;
	private $_cookieFileLocation = '/www/tmp/cookie.txt';
	private $_post;
	private $_postFields;
	private $_referer = '';
	private $_webpage;
	private $_includeHeader;
	private $_noBody;
	private $_status;
	private $_error;
	private $_requestInfo;
	private $_binaryTransfer;
	private	$_authentication = False;
	private	$_authName		= '';
	private	$_authPass		= '';

	public function __construct($url, $followlocation=True, $timeOut=30, $maxRedirecs=4, $binaryTransfer=False, $includeHeader=False, $noBody=False) {
		$this->_url = $url;
		$this->_followlocation = $followlocation;
		$this->_timeout = $timeOut;
		$this->_maxRedirects = $maxRedirecs;
		$this->_noBody = $noBody;
		$this->_includeHeader = $includeHeader;
		$this->_binaryTransfer = $binaryTransfer;
		$this->_cookieFileLocation = $this->_cookieFileLocation;
	}

	public function useAuth($use=True){
		$this->_authentication = False;
		if($use) {
			$this->_authentication = True;
		}
	}

	public function setName($name){
		$this->_authName = $name;
	}
	public function setPass($pass){
		$this->_authPass = $pass;
	}

	public function setReferer($referer){
		$this->_referer = $referer;
	}

	public function setCookieFileLocation($path) {
		$this->_cookieFileLocation = $path;
	}

	public function setPostFields($postDataArray) {
		$pairs = array();
		foreach($postDataArray as $key => $value) {
			$pairs[] = sprintf("%s=%s", $key, urlencode($value));
		}
		$this->_postFields = join('&', $pairs);
	}
	public function setPostData($postData) {
		# postData is string like "varName=foo&varName2=bar"
		$this->_post = True;
		$this->_postFields = $postData;
	}

	public function setUserAgent($userAgent) {
		$this->_useragent = $userAgent;
	}

	public function getRequestInfo() {
		return $this->_requestInfo;
	}

	public function getError() {
		return $this->_error;
	}

	public function getHttpStatus() {
		return $this->_status;
	}

	public function getWebpage() {
		return $this->_webpage;
	}

	public function doRequest($url = 'nul') {
		 if($url != 'nul'){
			 $this->_url = $url;
		 }

		$s = curl_init();

		curl_setopt($s, CURLOPT_URL,			$this->_url);
		curl_setopt($s, CURLOPT_HTTPHEADER,		array('Expect:'));
		curl_setopt($s, CURLOPT_TIMEOUT,		$this->_timeout);
		curl_setopt($s, CURLOPT_MAXREDIRS,		$this->_maxRedirects);
		curl_setopt($s, CURLOPT_RETURNTRANSFER,	True);
		curl_setopt($s, CURLOPT_FOLLOWLOCATION,	$this->_followlocation);
		curl_setopt($s, CURLOPT_COOKIEJAR,		$this->_cookieFileLocation);
		curl_setopt($s, CURLOPT_COOKIEFILE,		$this->_cookieFileLocation);
		curl_setopt($s, CURLOPT_SSL_VERIFYPEER, False);
		curl_setopt($s, CURLOPT_USERAGENT,		$this->_useragent);
		curl_setopt($s, CURLOPT_REFERER,		$this->_referer);

		if($this->_authentication){
			curl_setopt($s, CURLOPT_USERPWD, $this->_authName.':'.$this->_authPass);
		}
		if($this->_post) {
			curl_setopt($s,CURLOPT_POST,True);
			curl_setopt($s,CURLOPT_POSTFIELDS,$this->_postFields);
		}

		if($this->_includeHeader) {
				curl_setopt($s,CURLOPT_HEADER,True);
		}

		if($this->_noBody) {
			curl_setopt($s,CURLOPT_NOBODY,True);
		}

		$this->_webpage = curl_exec($s);
		$this->_status = curl_getinfo($s,CURLINFO_HTTP_CODE);
 	 	$this->_error = curl_error($s);
 	 	$this->_requestInfo = curl_getinfo($s);
		curl_close($s);
	}
} 


?>
