
CREATE TABLE IF NOT EXISTS `categories` (
  `category_id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) NOT NULL default '0',
  `prio` int(11) NOT NULL default '0',
  `hide` tinyint(4) NOT NULL default '0',
  `template` varchar(128) NOT NULL default '',
  `adminmodule` varchar(128) NOT NULL default 'content',
  `module` varchar(128) NOT NULL default 'contentshow',
  `edittime` int(11) NOT NULL default '0',
  `public` tinyint(4) NOT NULL default '0',
  `styleclass` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`category_id`, `parent_id`, `prio`, `hide`, `template`, `adminmodule`, `module`, `edittime`, `public`, `styleclass`) VALUES
(1, 0, 0, 1, 'admin', 'categories', '', 1282662215, 0, ''),
(2, 0, 0, 1, 'Default', 'usermanagement', 'login', 1282662215, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `category_files`
--

CREATE TABLE IF NOT EXISTS `category_files` (
  `item_id` int(11) NOT NULL default '0',
  `myfile` varchar(128) NOT NULL default '',
  `num` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`item_id`,`num`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `category_files`
--


-- --------------------------------------------------------

--
-- Table structure for table `category_texts`
--

CREATE TABLE IF NOT EXISTS `category_texts` (
  `name` varchar(128) NOT NULL default '',
  `page_title` varchar(128) NOT NULL default '',
  `urlname` varchar(64) NOT NULL default '',
  `language` varchar(2) NOT NULL default '',
  `category_id` int(11) NOT NULL default '0',
  `metaDescription` mediumtext NOT NULL,
  `metaKeywords` mediumtext NOT NULL,
  PRIMARY KEY  (`language`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `category_texts`
--

INSERT INTO `category_texts` (`name`, `page_title`, `urlname`, `language`, `category_id`, `metaDescription`, `metaKeywords`) VALUES
('Menu Manager', '', 'Menu_Manager', 'nl', 1, '', ''),
('User Manager', '', 'User_Manager', 'nl', 2, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `content`
--

CREATE TABLE IF NOT EXISTS `content` (
  `itemId` int(11) NOT NULL auto_increment,
  `categoryId` int(11) NOT NULL default '0',
  `addTime` int(11) default '0',
  `changeTime` int(11) default '0',
  `prio` int(11) NOT NULL default '0',
  `hide` int(11) NOT NULL default '0',
  `dataFields` longblob NOT NULL,
  `title` varchar(128) NOT NULL default '0',
  `sortDate` int(11) NOT NULL default '0',
  `archive` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`itemId`,`categoryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `content`
--


-- --------------------------------------------------------

--
-- Table structure for table `content_files`
--

CREATE TABLE IF NOT EXISTS `content_files` (
  `item_id` int(11) NOT NULL default '0',
  `myfile` varchar(128) NOT NULL default '',
  `num` tinyint(4) NOT NULL default '0',
  `filesize` int(11) NOT NULL default '0',
  `subscript` varchar(255) NOT NULL,
  PRIMARY KEY  (`item_id`,`num`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `content_files`
--


-- --------------------------------------------------------

--
-- Table structure for table `content_links_texts`
--

CREATE TABLE IF NOT EXISTS `content_links_texts` (
  `itemId` int(11) NOT NULL default '0',
  `language` varchar(2) NOT NULL default '',
  `field1` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`itemId`,`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `content_links_texts`
--


-- --------------------------------------------------------

--
-- Table structure for table `item_urls`
--

CREATE TABLE IF NOT EXISTS `item_urls` (
  `itemId` int(11) NOT NULL default '0',
  `category_id` int(11) NOT NULL default '0',
  `language` varchar(2) NOT NULL default '',
  `urlname` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`itemId`,`category_id`,`language`),
  KEY `urlname` (`urlname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `item_urls`
--


-- --------------------------------------------------------

--
-- Table structure for table `macromodules`
--

CREATE TABLE IF NOT EXISTS `macromodules` (
  `macromoduleId` int(11) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `module` varchar(128) NOT NULL default '',
  `adminmodule` varchar(128) NOT NULL default '',
  `template` varchar(128) NOT NULL default '',
  `description` text NOT NULL,
  PRIMARY KEY  (`macromoduleId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

--
-- Dumping data for table `macromodules`
--

INSERT INTO `macromodules` (`macromoduleId`, `name`, `module`, `adminmodule`, `template`, `description`) VALUES
(6, 'contact', 'contactform', 'content', 'contact', 'Website Contact formulier'),
(2, 'Nieuws', 'contentshow', 'content', 'moreitems', 'Nieuws module, meerdere items op 1 pagina'),
(3, 'Static page', 'contentshow', 'content', 'Default', 'Standaard pagina met default template'),
(7, 'Login', 'login', '-', '-', 'Login box'),
(8, 'Show first submenu', 'contentmultiple', '-', 'showfirstsub', 'laat de inhoud van eerste onderliggende menu zien.');

-- --------------------------------------------------------

--
-- Table structure for table `um_actionLog`
--

CREATE TABLE IF NOT EXISTS `um_actionLog` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) collate latin1_general_ci NOT NULL,
  `neededPermission` varchar(255) collate latin1_general_ci NOT NULL,
  `categoryId` int(11) NOT NULL,
  `method` varchar(255) collate latin1_general_ci NOT NULL,
  `user` varchar(255) collate latin1_general_ci NOT NULL,
  `ip` varchar(255) collate latin1_general_ci NOT NULL,
  `requestUri` mediumtext collate latin1_general_ci NOT NULL,
  `requestTime` bigint(20) NOT NULL,
  `args` longtext collate latin1_general_ci NOT NULL,
  `request` longtext collate latin1_general_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `um_actionLog`
--

INSERT INTO `um_actionLog` (`id`, `name`, `neededPermission`, `categoryId`, `method`, `user`, `ip`, `requestUri`, `requestTime`, `args`, `request`) VALUES
(1, 'login', '', 0, 'login', 'admin', '83.163.18.105', '/paymentsystem/admin/?action=login', 1282662235, '(username:admin) (password:asdf) ', '(username:admin) (password:asdf) (login:Login) (action:login) ');

-- --------------------------------------------------------

--
-- Table structure for table `um_category2settings`
--

CREATE TABLE IF NOT EXISTS `um_category2settings` (
  `categoryId` bigint(20) NOT NULL default '0',
  `id` varchar(255) NOT NULL default '',
  `value` varchar(255) NOT NULL default '0',
  PRIMARY KEY  (`categoryId`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `um_category2settings`
--


-- --------------------------------------------------------

--
-- Table structure for table `um_group2permissions`
--

CREATE TABLE IF NOT EXISTS `um_group2permissions` (
  `groupId` bigint(20) NOT NULL default '0',
  `categoryId` bigint(20) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `value` int(11) NOT NULL default '0',
  PRIMARY KEY  (`groupId`,`categoryId`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `um_group2permissions`
--


-- --------------------------------------------------------

--
-- Table structure for table `um_group2settings`
--

CREATE TABLE IF NOT EXISTS `um_group2settings` (
  `groupId` bigint(20) NOT NULL default '0',
  `categoryId` bigint(20) NOT NULL default '0',
  `id` varchar(255) NOT NULL default '',
  `value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`groupId`,`categoryId`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `um_group2settings`
--


-- --------------------------------------------------------

--
-- Table structure for table `um_groups`
--

CREATE TABLE IF NOT EXISTS `um_groups` (
  `groupId` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `parentUserId` int(11) NOT NULL default '0',
  PRIMARY KEY  (`groupId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

--
-- Dumping data for table `um_groups`
--

INSERT INTO `um_groups` (`groupId`, `name`, `parentUserId`) VALUES
(1, 'Super Users', 1),
(2, 'Guest', 1);

-- --------------------------------------------------------

--
-- Table structure for table `um_ranges`
--

CREATE TABLE IF NOT EXISTS `um_ranges` (
  `rangeId` bigint(20) NOT NULL auto_increment,
  `a` char(3) NOT NULL default '',
  `b` char(3) NOT NULL default '',
  `c` char(3) NOT NULL default '',
  `d` char(3) NOT NULL default '',
  `priority` int(11) NOT NULL default '0',
  `userId` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`rangeId`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

--
-- Dumping data for table `um_ranges`
--

INSERT INTO `um_ranges` (`rangeId`, `a`, `b`, `c`, `d`, `priority`, `userId`) VALUES
(1, '*', '*', '*', '*', 0, 2);

-- --------------------------------------------------------

--
-- Table structure for table `um_user2permissions`
--

CREATE TABLE IF NOT EXISTS `um_user2permissions` (
  `userId` bigint(20) NOT NULL default '0',
  `categoryId` bigint(20) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `value` int(11) NOT NULL default '0',
  PRIMARY KEY  (`userId`,`categoryId`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `um_user2permissions`
--


-- --------------------------------------------------------

--
-- Table structure for table `um_user2settings`
--

CREATE TABLE IF NOT EXISTS `um_user2settings` (
  `userId` bigint(20) NOT NULL default '0',
  `categoryId` bigint(20) NOT NULL default '0',
  `id` varchar(255) NOT NULL default '',
  `value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`userId`,`categoryId`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `um_user2settings`
--


-- --------------------------------------------------------

--
-- Table structure for table `um_users`
--

CREATE TABLE IF NOT EXISTS `um_users` (
  `userId` bigint(20) NOT NULL auto_increment,
  `username` varchar(255) NOT NULL default '',
  `password` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `lastLogin` bigint(20) NOT NULL default '0',
  `groupId` bigint(20) NOT NULL default '0',
  `parentUserId` int(11) NOT NULL default '0',
  `isSuperUser` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`userId`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

--
-- Dumping data for table `um_users`
--

INSERT INTO `um_users` (`userId`, `username`, `password`, `email`, `lastLogin`, `groupId`, `parentUserId`, `isSuperUser`) VALUES
(1, 'admin', 'asdf', 'admin@datact.nl', 1282662235, 1, 1, 1),
(2, 'Guest', 'guest', 'guest@datact.nl', 0, 2, 1, 0);

