<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT    
 * date created			: 12-01-08
 * date modified		: $Id$
 */

$catconf = $GLOBALS['catconf'];


//example:
//$userManager = new UserManager();
//$userManager->getLoggedInUser();
//if(isset($_GET['delete']) and $user->hasPermission($SE..., "managecattree:delete")) {
if(!isset($_SESSION['selectedAdminCat'])) {
	$_SESSION['selectedAdminCat'] = 0;
}

if(isset($_GET['hide'])) {
	$hideid = (int)$_GET['hide'];
	$category = new Category($hideid);
	$category->toggleHide();
	$category->save();
}

if(isset($_GET['togglepublic'])) {
	$id = (int)$_GET['togglepublic'];
	$category = new Category($id);
	$category->togglePublic();
	$category->save();
}

if(isset($_GET['delete'])) {
	$categoryId = $_GET['delete'];
	$category = new Category($categoryId);
	$parent_id = $category->getParentId();
	if ($parent_id != 0 or $catconf['allow_top_level_extension']) {
		$category->delete();
		$_SESSION['selectedAdminCat'] = $parent_id;
		$_SESSION['messages'][] = $text['deleted'];
	} else {
		$_SESSION['messages'][] = $text['unabletodeletetoplevel'];
	}
	unset($category);
}

$scat = $_SESSION['selectedcat'];
$Cid = $_SESSION['selectedAdminCat'];

$categoryManager = new CategoryManager($catconf);
if(isset($_GET['move'])) {
	$moveid = (int)$_GET['move'];
	$direction = $_GET['direction'];
	$categoryManager->moveCategoryPosition($moveid, $direction);
}

$categoryManager->clearCache(true);
$categoryManager->setExpandLevel(0);

/* veranderd 16 juli 09 ook hidden cats laten zien maar alleen als er rechten op zijn
//Als hij op de huidge category manager basicmanager heeft en hij is een normale gebruiker
if($user->hasPermission(getSelectedCat(), "managecattree:basicmenumanager") && !$user->isSuperUser()){
	$categoryManager->showHidden(false);
} else {
	$categoryManager->showHidden(true);
}
*/
$categoryManager->showHidden(true);

$categoryManager->setSelectedCategoryId($Cid);
$CatTree = $categoryManager->getSelectedCategoryTree();

$mod->assign("CATCONF", $catconf);
$mod->parse('module.top_level_allowed', "managecattree:newTop");
$mod->parse('module.advanced', "editcategory:advanced");
$mod->parse('module.allow_new', "managecattree:new");
$mod->parse('module.allow_hide', "managecattree:hide");
$mod->parse('module.allow_edit', "managecattree:edit");
#((isset($catconf['allow_settings']) && $catconf['allow_settings']) ? $mod->parse('module.allow_settings') : true );
$mod->parse('module.allow_settings', "managecattree:settings");
$mod->parse('module.publicswitch', "managecattree:publicswitch");
$mod->parse('module.allow_trash', "managecattree:trash");
$mod->parse('module.allow_move', "managecattree:move");

if ($catconf['allow_top_level_extension']) {
		$mod->parse('module.top_level_extension_enabled');
} else {
		$mod->parse('module.top_level_extension_disabled');
}

$maxDepth = $catconf['max_depth'];
foreach($CatTree as $category) {
	$mod->assign('CATEGORY', $category->getXTemplateData());
	$userManager = new UserManager();
	$user = $userManager->getLoggedInUser();

#	if(!$mod->hasPermissionForCategory($category->getCategoryId()) and !$user->hasPermission(getSelectedCat() ,"managecattree:basicmenumanager")) {
	if(!$mod->hasPermissionForCategory($category->getCategoryId())) {
		continue;
	}
	if($category->getAdminModule() == 'categories' && !$user->isSuperUser()) {
		continue;
	}

	if($categoryManager->countChildrenFromParentId($category->getParentId()) > 1){
		$mod->parse('module.category.allow_move.move_enabled', "managecattree:move");
	} else {
		$mod->parse('module.category.allow_move.move_disabled', "managecattree:move");
	}
	if ($category->isHidden()) {
		$mod->parse('module.category.allow_hide.hidden', "managecattree:hide");
	} else {
		$mod->parse('module.category.allow_hide.show', "managecattree:hide");
	}
	if (!$category->isPublic()) {
		$mod->parse('module.category.publicswitch.public', "managecattree:publicswitch");
	} else {
		$mod->parse('module.category.publicswitch.private', "managecattree:publicswitch");
	}

	//FIXME check if isset
	$mod->parse('module.category.allow_hide', "managecattree:hide");
	$mod->parse('module.category.publicswitch', "managecattree:publicswitch");
	$mod->parse('module.category.allow_edit', "managecattree:edit");
	$mod->parse('module.category.allow_trash', "managecattree:trash");
	$mod->parse('module.category.allow_settings', "managecattree:settings");
	$mod->parse('module.category.allow_move', "managecattree:move");

	if ($category->getLevel() < $maxDepth ) {
		$mod->parse('module.category.new_enabled', "managecattree:new");
	} else {
		$mod->parse('module.category.new_disabled', "managecattree:new");
	}
	
	if($category->getCategoryId() == $scat) {
		$mod->parse('module.category.selected');
	} else {
		$mod->parse('module.category.normal');
	}
	$mod->parse('module.category');
}
?>
