<?php

/*
 * Author				: E J Jonkers    
 * company/copyright	: DataCT    
 * date created			: 09-06-10
 * date modified		: 
 */

class ContactFormController extends AbstractController {
    public function __construct($mod, $text=array()) {
        parent:: __construct($mod, $text);
		$action = new Action("submitContactForm", False, 'processForm');
		$this->addAction($action);

		$action = new Action("lister");
		$this->setDefaultAction($action);
	
	}
	public function processForm() {
		$userManager = new UserManager();
		$user = $userManager->getLoggedInUser();
		$settings = $user->getSettingsArrayForCategory(getSelectedCat());
		if(isset($_POST['send']) && isset($_POST['wonder']) && $_POST['wonder'] == "") {
			$contactConfigPath = BASEPATH."modules/contactform2/configs/contactform.inc.php";
			if(!file_exists($contactConfigPath)) {
				$contactConfigPath = BASEMODULESPATH."modules/contactform2/configs/contactform.inc.php";
			}
			$contactContent = new Content(false, $contactConfigPath);
			$contactContent->setCategoryId(getSelectedCat());
			$contactContent->readFromForm();
			if(!$contactContent->hasValidateError()){
				$mail = new PHPMailer();
				$mail->From     = $settings['from'];
				$mail->FromName = $settings['fromname'];
				$mail->Host     = $settings['mailhost'];
				$mail->Subject  = $settings['subject'];
				$mail->Mailer   = "smtp";
				$body = array();
				$body[] = $settings['mailIntro']." ". $contactContent->getValue("name") .",\n" ;
				$body[] = $settings['messageForClient'] ."\n";
				foreach($contactContent->getFields() as $field) {
					$fieldname = $field->getFieldName();
					$body[] = $this->text($fieldname).": ". $field->getValue();
					if($fieldname == 'email') {
						$visitorEmail = $field->getValue();
					}
				}
				$bodystring = join("\n", $body);
		
				$mail->Body    = nl2br($bodystring);
				$mail->AltBody = $bodystring;
				$mail->AddAddress($settings['to'], "");
				if(isset($visitorEmail)) {
					$mail->AddBCC($visitorEmail, "");
				}
			
				if(!$mail->Send()) {
					$mod->assign('CONTACT', $contactContent->getTemplateData());
					$this->message("contactformNotSent");
				} else {
					$this->message("contactformSent");
				}
	
				$mail->ClearAddresses();
				$contactContent->save();
			} else {
				$this->message('errorfield', $contactContent->getErrorFields());
				$this->mod->assign('CONTACT', $contactContent->getTemplateData());
			}
		}
		$this->lister();
	}
	public function lister() {
		global $mydb;
		$query = "show tables";
		$tablesResult = $mydb->executeQuery($query);
		$foundTable = False;
		while($table = mysql_fetch_array($tablesResult)) {
			if($table[0] == 'contacts') {
				$foundTable = True;
				break;
			}
		}
		if(!$foundTable) {
			$this->message('ERROR CREATE TABLE: contacts');
		}
		# show form
	    $contactConfigPath = BASEPATH."modules/contactform2/configs/config.inc.php";
	    if(!file_exists($contactConfigPath)) {
	        $contactConfigPath = BASEMODULESPATH."modules/contactform2/configs/config.inc.php";
	    }
		$contentManager = new ContentManager(getSelectedCat(), $contactConfigPath);

		list($contactContent) = $contentManager->getContentItems();
		$item = $contactContent->getTemplateData();
		$this->mod->assign('CONTENT', $item);
		if(isset($item['photo']) && is_array($item['photo'])) {
            foreach($item['photo'] as $photo){
				$newphoto['small'] = mypicture( $photo['myfile'], 'small');
				$newphoto['medium'] = mypicture( $photo['myfile'], 'medium');
				$newphoto['large'] = mypicture( $photo['myfile'], 'large');
				$photos[] = $newphoto;
			}
			foreach($photos as $photo){
				$this->mod->assign('PHOTOSMALL', $photo['small']);
				$this->mod->assign('PHOTOMEDIUM', $photo['medium']);
				$this->mod->assign('PHOTOLARGE', $photo['large']);
				$this->mod->parse('module.photo');
			}

		}

	}
}
?>
