<?php

/*
 * Author				: E J Jonkers    
 * company/copyright	: DataCT    
 * date created			: 09-06-10
 * date modified		: 
 */

class ContactFormController extends AbstractController {
    public function __construct($mod, $text=array(), $config=False) {
        parent:: __construct($mod, $text);
		$this->contentConf = $config;

		$this->listTemplate = isset($this->contentConf['listTemplate']) ? $this->contentConf['listTemplate'] : 'submittedContactsList';
		$action = new Action("showSubmittedData");
		$this->addAction($action);
		$action = new Action("deleteformEntry");
		$this->addAction($action);

		$action = new Action("lister");
		$this->setDefaultAction($action);
	
		$this->contactConfigPath = BASEPATH."modules/contactform2/configs/contactform.inc.php";
		if(!file_exists($this->contactConfigPath)) {
			$this->contactConfigPath = BASEMODULESPATH."modules/contactform2/configs/contactform.inc.php";
		}
		
	}
	public function deleteformEntry() {
		$id = $this->currentAction->getArgumentValue('id');
		$c = new Content($id, $this->contactConfigPath);
		$c->delete();
		$this->message('deleted');
		$this->showSubmittedData();
	}
	public function showSubmittedData() {
		$contentManager = new ContentManager(getSelectedCat(), $this->contactConfigPath);
		$list = new Listing();
		$list->setNoSorting();
		$contentItems = $contentManager->getContentItems();
		foreach($contentItems as $contentItem) {
			$list->addRecord($contentItem->getTemplateData());
		}
		$this->mod->assign("ITEMS", domodule('lister', '', $this->listTemplate, array('list' => $list, 'text' => $this->text)));
	}
	public function lister() {
		# show form
		global $mydb;
		$query = "show tables";
		$tablesResult = $mydb->executeQuery($query);
		$foundTable = False;
		while($table = mysql_fetch_array($tablesResult)) {
			if($table[0] == 'contacts') {
				$foundTable = True;
				break;
			}
		}
		if(!$foundTable) {
			$this->message('ERROR CREATE TABLE: contacts');
		}

		$this->mod->assign('CONTENT', domodule('content2', '', $this->contentConf['contentAdminTemplate']));
	}
}
?>
