<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT	
 * date created			: 26-06-08
 * date modified		: $Id$
 */

class content2Controller extends AbstractController {
	private $path;
	private $contentConf;
	private $listTemplate;
	private $settings;
	private $enableHide;
	private $enableArchive;
	private $enableMove;
	private $hasLanguageDependentFields;

	public function __construct($mod, $text=array(), $config=False ) {
		parent:: __construct($mod, $text);
		$this->contentConf = $config;

		$this->listTemplate = isset($this->contentConf['listTemplate']) ? $this->contentConf['listTemplate'] : 'defaultListTemplate';
		$this->enableHide = isset($this->contentConf['enableHide']) ? $this->contentConf['enableHide'] : False;
		$this->enableArchive = isset($this->contentConf['enableArchive']) ? $this->contentConf['enableArchive'] : False;
		$this->enableMove = isset($this->contentConf['enableMove']) ? $this->contentConf['enableMove'] : False;
		$this->pageSize = isset($this->contentConf['pagesize']) ? $this->contentConf['pagesize'] : 20;
		$this->settings = array();

		$um = new UserManager();
		$user = $um->getLoggedInUser();
		if($user){
			$this->settings = $user->getSettingsArrayForCategory(getSelectedCat());
			if(isset($this->settings['orderField'])) {
				$this->contentConf['orderField'] = $this->settings['orderField'];
			}
			if(isset($this->settings['orderDirection'])) {
				$this->contentConf['orderDirection'] = $this->settings['orderDirection'];
			}
			if(isset($this->settings['number_of_files'])) {
				$this->contentConf['number_of_files'] = $this->settings['number_of_files'];
			}
			if(isset($this->settings['enableMCE'])) {
				$this->contentConf['enableMCE'] = $this->settings['enableMCE'];
			}
			if(isset($this->settings['advancedMCE'])) {
				$this->contentConf['advancedMCE'] = $this->settings['advancedMCE'];
			}
			if(isset($this->settings['totalItems'])) {
				$this->contentConf['totalItems'] = $this->settings['totalItems'];
			}
		}

		$this->hasLanguageDependentFields = False;
		foreach($this->contentConf['fields'] as $fieldName => $field) {
			if(isset($field['languageDependent']) && $field['languageDependent']) {
				$this->hasLanguageDependentFields = True;
				break;
			}
		}



		$action = new Action("archive", false, false, array(), false, true);
		$action->addArgument("id", INT);
		$this->addAction($action);

		$action = new Action("hide", false, false, array(), false, true);
		$action->addArgument("id", INT);
		$this->addAction($action);

		$action = new Action("edit", false, false, array(), false, true);
		$this->addAction($action);

		$action = new Action("delete", false, false, array(), true, true);
		$this->addAction($action);

		$action = new Action("deleteFile", false, false, array(), false, true);
		$action->addArgument("id", INT);
		$this->addAction($action);

		$action = new Action("move", false, false, array(), false, true);
		$action->addArgument("id", INT);
		$action->addArgument("direction", ALL);
		$this->addAction($action);

		$action = new Action("add", false, false, array(), false, true);
		$this->addAction($action);

		$action = new Action("lister");
		$this->setDefaultAction($action);
	}
	
	public function noList() {
		return $this->contentConf['totalItems'] == 1;
	}

	public function edit() {
		$id = isset($this->id) ? $this->id : $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
		} else {
			$content = new Content(false, false,$this->contentConf);
		}

		$this->showForm($content);
	}

	public function add() {
		$id = $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
		} else {
			$content = new Content(false, false,$this->contentConf);
		}

		$content->setCategoryId(getSelectedCat());
		
		if($content->readFromForm()){
			$content->save();
			$this->message('saved');
			if(isset($_REQUEST['saveAndStay'])) {
				$this->showForm($content);
			} else {
				$this->lister();
			}
		} else {
			$_SESSION['messages'][] = $this->text('fielderror').' '.join(',', $content->getErrorFields());
			$this->showForm($content);
		}
	}

	public function delete() {
		# todo extra controle op categoryId
		$id = $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
			$content->delete();
		}
	}	
		
	public function showForm($content = false) {
		if(!$content){
			$content = new Content(false, false,$this->contentConf);
		}
		
		foreach($GLOBALS['available_languages'] as $language => $langName) {
			$this->mod->assign('THISLANGUAGE', $langName);
			$this->mod->assign('THISLANG', $language);
			if($content){
				$this->mod->assign('ITEM', $content->getTemplateData($language));
			}
			if($this->hasLanguageDependentFields) {
				$this->mod->parse('module.itemfields.language_dependant');
			}
		}
		$this->showSelectInputs($content);
		$this->mod->parse('module.itemfields');
		$this->showFileForm($content);
		if(!$this->noList()) {
			$this->mod->parse('module.formparts.stayButton');
		}
		$this->mod->parse('module.formparts');

		if ($this->contentConf['enableMCE'] == 'True') {
			if ($this->contentConf['advancedMCE'] == 'True') {
				$this->mod->assign('TINYMCETHEME', 'advanced');
			} else {
				$this->mod->assign('TINYMCETHEME', 'simple');
			}
			$this->mod->parse('module.tinyMCEConfig');
		}
	}

	public function showSelectInputs($content = false) {
		# for each content->getSelectTypeFields
		# path module.naam.option
		# module.naam
		foreach($content->getSelectTypeFields() as $s) {
			$fieldName = $s->getFieldName();
			foreach($s->getSelectOptions() as $option) {
				$this->mod->assign('optionKey', $option['optionKey']);
				$this->mod->assign('optionValue', $option['optionValue']);
				$this->mod->assign('optionSelected', $option['optionSelected']);
				$this->mod->parse('module.itemfields.'.$fieldName.'.option');
			}
			$this->mod->parse('module.itemfields.'.$fieldName);
		}
	}
	public function showFileForm($content = false) {
		if($this->contentConf['number_of_files']) {
			parsefiles($content->getFiles(), &$this->mod, $this->contentConf['number_of_files']);
		}
	}

	public function move() {
		$id = $this->currentAction->getArgumentValue("id");
		$direction = $this->currentAction->getArgumentValue("direction");
		if($id <> '' and $direction <> ''){
			$contentManager = new ContentManager(getSelectedCat(), false, $this->contentConf);
			$contentManager->moveContentItemPosition($id, $direction);
		}
		$this->lister();
	}

	public function hide() {
		$id = $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
			$content->toggleHide();
			$content->save();
		}
		$this->lister();
	}

	public function archive() {
		$id = $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
			if($content->getValue("archive") == "1"){
				$content->setFieldValue("archive", "0");
			} else {
				$content->setFieldValue("archive", "1");
			}
			$content->save();
		}
		$this->lister();
	}

	public function deleteFile() {
		$file = $this->currentAction->getArgumentValue("file");
		$id = $this->currentAction->getArgumentValue("id");
		if($id <> ""){
			$content = new Content($id, false,$this->contentConf);
			$content->deleteFile($file);
		}
		$this->showForm($content);
	}

	public function lister() {
		if ($this->noList()) {
			// als er toch maar een item kan zijn, kunnen we de lister-stap wel helemaal overslaan...
			$contentManager = new ContentManager(getSelectedCat(), false, $this->contentConf);
			$items = $contentManager->getContentItems();
			$this->id = isset($items[0]) ? $items[0]->getItemId() : false;
			$this->edit();
		} else {
			$contentManager = new ContentManager(getSelectedCat(), false, $this->contentConf);
			$items = $contentManager->getContentItems();
			$list = new Listing();
			$list->setPageSize($this->pageSize);
			foreach($items as $item) {
				$list->addRecord($item->getTemplateData());
			}
			if(count($items) < $this->contentConf['totalItems']) {
				$this->mod->parse('module.newButton');
			}
		
			$this->mod->assign("ITEMS",domodule('lister', '', $this->listTemplate, array('list' => $list, 'text' => $this->text)));
		}
	}
}
?>
