<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 26-06-08
 * date modified		: $Id$
 */

class ContentShowController extends AbstractController {
	private $path;
	private $contentConf;
	private $selectedItem;
	private $contentManager;

	public function __construct($mod, $text=array(), $contentConf=False) {
		parent:: __construct($mod, $text);
		$userm = new UserManager();
		$user = $userm->getLoggedInUser();
        $this->settings = $user->getSettingsArrayForCategory($_SESSION['selectedcat']);

		if(!$contentConf) {
			$this->mainPath = BASEMODULESPATH ."modules/content/configs/config.inc.php";
			$this->path = BASEMODULESPATH ."modules/content2/configs/config.inc.php";
			include($this->mainPath);	
			include($this->path);	
		}
		
		$this->contentConf = array_merge($contentConf, $this->settings);
#		if(isset($this->settings[''])) {
#			$this->contentConf[''] = $this->settings[''];
#		}
		if(isset($this->settings['template'])) {
			$this->contentConf['template'] = $this->settings['template'];
		}
		if(isset($this->settings['archivetemplate'])) {
			$this->contentConf['archivetemplate'] = $this->settings['archivetemplate'];
		}
		if(isset($this->settings['enableRandom'])) {
			$this->contentConf['enableRandom'] = $this->settings['enableRandom'];
		}
		if(isset($this->settings['randomItems'])) {
			$this->contentConf['randomItems'] = $this->settings['randomItems'];
		}
		$this->contentManager = new ContentManager(getSelectedCat(), false, $this->contentConf);

		$this->selectItem();

		$action = new Action("showArchive");
		$this->addAction($action);

		$action = new Action("rss");
		$action->setDefaultActionAllowed(false);
		$this->addAction($action);

		$action = new Action("show");
		$this->setDefaultAction($action);
	}
	public function selectItem() {
		if(isset($GLOBALS['GHOSTPAGE']['filename']) && $GLOBALS['GHOSTPAGE']['filename'] <> ""){
			$this->selectedItem = new Content($this->contentManager->getItemIdFromUrlName($GLOBALS['GHOSTPAGE']['filename'], getSelectedCat(), $GLOBALS['language']), false, $this->contentConf);
		} else {
			$this->selectedItem = False;
		}
	}

	public function showArchive() {
		$this->contentManager->setEnableRandom(False);
		$this->mod->parse('module.terug.recent');
		$this->mod->parse('module.terug');
		$this->show(1);
	}
	
	public function show($archive = 0) {
		$search = array();
		if ($this->contentConf['totalItems'] > 1) {
			if (isset($this->contentConf['enableArchive']) && $this->contentConf['enableArchive'] == 'True') {
				$search['archive'] = $archive;
			}
			if (isset($this->contentConf['enableHide']) && $this->contentConf['enableHide'] == 'True') {
				$search['hide'] = "0";
			}
		}
		$items = $this->contentManager->getContentItems($search, $this->contentConf['orderField'], $this->contentConf['orderDirection']);
		if($this->contentConf['totalItems'] == 1) {
			if (isset($items[0])) {
				$item = $items[0]->getTemplateData();
	
				// fotos eventueel resizen
				$photos = $this->resizePhotos($item);
				$item['photos'] = $photos;
				$this->addPhotos($photos, 'module.singleitem.photo');
				$this->mod->assign("ITEM", $item);
				$this->mod->parse('module.singleitem');
			}
		} else {
			if(!$this->selectedItem){
				$list = new Listing();
				if(isset($this->contentConf['pagesize'])) {
					$list->setPageSize($this->contentConf['pagesize']);
				}
 				if($archive == "0" && isset($this->contentConf['enableArchive']) && $this->contentConf['enableArchive'] == 'True') {
 					$this->mod->parse('module.archive');
				}
				foreach($items as $item) {
					$templateData = $item->getTemplateData();

					$photos = $this->resizePhotos($templateData);
					$templateData['photos'] = $photos;
					$list->addRecord($templateData);
				}
				if($archive == 0){
					$this->mod->assign("CONTENTITEMS",domodule('lister', '', $this->contentConf['template'], array('list' => $list)));
				} else {
					$this->mod->assign("CONTENTITEMS",domodule('lister', '', $this->contentConf['archivetemplate'], array('list' => $list)));
				}
			} else {
				$this->mod->parse('module.terug');
				$item = $this->selectedItem->getTemplateData();

				// fotos eventueel resizen
                $photos = $this->resizePhotos($item);
                $item['photos'] = $photos;
				$this->addPhotos($photos, 'module.singleitem.photo');

				$this->mod->assign("ITEM", $item);
				$this->mod->parse('module.singleitem');
			}
		}
	}

	public function resizePhotos($item) {
		// fotos eventueel resizen
		$photos = array();
		if(isset($item['photo']) && is_array($item['photo'])) {
            foreach($item['photo'] as $photo){
				$newphoto['small'] = mypicture( $photo['myfile'], 'small');
				$newphoto['medium'] = mypicture( $photo['myfile'], 'medium');
				$newphoto['large'] = mypicture( $photo['myfile'], 'large');
				if(isset($photo['subscript'])) {
					$newphoto['subscript'] = $photo['subscript'];
				}
				$photos[] = $newphoto;
			}
		}
		return $photos;
	}

	public function addPhotos($photos, $photoModPath) {
		foreach($photos as $photo){
			$this->mod->assign('PHOTOSMALL', $photo['small']);
			$this->mod->assign('PHOTOMEDIUM', $photo['medium']);
			$this->mod->assign('PHOTOLARGE', $photo['large']);
			if(isset($photo['subscript'])) {
				$this->mod->assign('subscript', $photo['subscript']);
			}
			$this->mod->parse($photoModPath);
		}
	}



	public function rss($archive = "0") {
		$search = array();
        if (!$this->contentConf['totalItems'] > 1) {
			if ($this->contentConf['enableArchive'] == 'True') {
    	        $search['archive'] = $archive;
        	}
	        if ($this->contentConf['enableHide'] == 'True') {
    	        $search['hide'] = "0";
        	}
		}
		$items = $this->contentManager->getContentItems($search);
		$list = new Listing();
		$list->setPageSize($this->contentConf['pagesize']);

		foreach($items as $item) {
			$list->addRecord($item->getTemplateData());
		}

		header('Content-type: text/xml');
		global $page;
		$page = new TemplateProxy("templates/empty.inc.html");
		$this->mod = new TemplateProxy(BASEMODULESPATH . "modules/newsshow/templates/rss.inc.html");

		$this->mod->assign("CONTENTITEMS",domodule('lister', '', 'newsshowrss', array('list' => $list)));
		echo $this->mod->parseModule('rss');
		exit;
	}


}
?>
