<?php

/*
 * Author			: E J Jonkers    
 * company			: DataCT    
 * date created		: 10-03-17
 * date modified	:     
 */

class Flashbanner2Controller extends AbstractController {
    public function __construct($mod, $text=array()) {
        parent::__construct($mod, $text);

        $Action = new Action('lister');
        $this->setDefaultAction($Action);

        $Action = new Action('getXML');
        $this->addAction($Action);

        $userManager = new UserManager();
        $user = $userManager->getLoggedInUser();
        $this->settings = $user->getSettingsArrayForCategory(getSelectedCat());
        $this->config = array_merge($GLOBALS['flashConf'], $this->settings);
        $this->xmlTemplate = BASEMODULESPATH.'modules/flashbanner/templates/'.$this->config['xmlTemplate'];
        if(!file_exists($this->xmlTemplate)) {
            $this->message('NoXMLTemplate');
        }
	}
	public function getXML() {
		$xmlTemplate = new XTemplate($this->xmlTemplate);
        $cm = new ContentManager(getSelectedCat(), '/www/cmsbase/modules/content2/configs/flashbanner.inc.php');

        $cs = $cm->getContentItems();
		foreach($cs as $c) {
			$ct = $c->getTemplateData();
			# todo resize image for correct width/height
#			$flashPic = mypicture($ct['photo'][1]['myfile'], '', $this->settings['width'], $this->settings['height'], 'flashbanner');
			$flashPic = mypicture($ct['photo'][1]['myfile'], '', $this->settings['width'], 0, 'flashbanner');
			$xmlTemplate->assign('picture', $flashPic['picture']);
			$xmlTemplate->assign('ITEM', $ct);
			if($ct['line1']) {
				$xmlTemplate->parse('module.item.line1');
			}
			if($ct['line2']) {
				$xmlTemplate->parse('module.item.line2');
			}
			$xmlTemplate->parse('module.item');
		}
		$xmlTemplate->assign('SETTINGS', $this->settings);

		$xmlTemplate->parse('module');
		echo $xmlTemplate->text('module');
		exit;
	}
	public function lister() {
		$cm = new CategoryManager();
		$catPath = $cm->getCategoryPathFromId(getSelectedCat());
		$this->mod->assign('SETTINGS', $this->settings);
		$this->mod->assign('CATPATH', $catPath);
	}

}

?>
