<?php

/*
 * Author				: E J Jonkers
 * company/copyright	: DataCT    
 * date created			: 11-06-08
 * date modified		: $Id$
 */

class LogViewerController extends AbstractController {
	public function __construct($mod, $text=array()) {
		parent:: __construct($mod, $text);
		$action = new Action("show");
		$this->setDefaultAction($action);
		$this->fullTree = True;
	}
	
	public function setBranchOnly() {
		$this->fullTree = False;
	}
	public function show() {
		global $mydb;
		//$this->currentAction->addArgument("sdate", ANYTHING);
		//$this->currentAction->addArgument("edate", ANYTHING);
		$times = 0;
		$timee = time();
		if($this->fullTree) {
			$query = "SELECT * FROM um_actionLog WHERE requestTime > $times AND requestTime < $timee order by requestTime desc";
		} else {
			$cm = new CategoryManager();
			$catIds = $cm->getAllChildrenIdsFromId(getSelectedCat());
			$cats = array("categoryId = '".getSelectedCat()."'");
			foreach($catIds as $catId) {
				$cats[] = "categoryId = '$catId'";
			}
			$catQuery = join(' or ', $cats);
			$query = "SELECT * FROM um_actionLog WHERE requestTime > $times AND requestTime < $timee and $catQuery order by requestTime desc";
		}
		$results = $mydb->convertRecordsToArray($mydb->executeQuery($query));
		$list = new Listing();
		$list->setDefaultSort('requestTime', 'down');
		foreach($results as $result){
			$requestTime = date(DATEFORMAT, $result['requestTime']);
			$result['date'] = $requestTime;
			$list->addRecord($result);
		}
		$this->mod->assign("EDATE", $timee);
		$this->mod->assign("SDATE", $times);
		$this->mod->assign("LOG",domodule('lister', '', 'logviewer', array('list' => $list)));
	}
}
?>
