<?php

/*
 * Author				: Ivo Hunink
 * company/copyright	: DataCT    
 * date created			: 26-06-08
 * date modified		: $Id$
 */

class NewsShowController extends AbstractController {
	private $path;
	private $contentConf;
	private $selectedItem;
	private $contentManager;

	public function __construct($mod, $text=array()) {
		parent:: __construct($mod, $text);

		$userm = new UserManager();
		$user = $userm->getLoggedInUser();
        $this->settings = $user->getSettingsArrayForCategory($_SESSION['selectedcat']);

		$this->mainPath = BASEMODULESPATH ."modules/content/configs/config.inc.php";
		if(!is_file(BASEPATH ."modules/content/configs/nieuws2.inc.php")){
			$this->path = BASEMODULESPATH ."modules/content/configs/nieuws2.inc.php";
		} else {
			$this->path = BASEPATH ."modules/content/configs/nieuws2.inc.php";
		}
		
		include($this->mainPath);	
		include($this->path);	
		$this->contentConf = $contentConf;
		$this->contentManager = new ContentManager(getSelectedCat(), false, $this->contentConf);

		$this->selectItem();

		$action = new Action("showArchive");
		$this->addAction($action);

		$action = new Action("rss");
		$action->setDefaultActionAllowed(false);
		$this->addAction($action);

		$action = new Action("show");
		$this->setDefaultAction($action);
	}

	public function selectItem() {
		if(isset($GLOBALS['GHOSTPAGE']['filename']) && $GLOBALS['GHOSTPAGE']['filename'] <> ""){
			$this->selectedItem = new Content($this->contentManager->getItemIdFromUrlName($GLOBALS['GHOSTPAGE']['filename'], getSelectedCat(), $GLOBALS['language']), false, $this->contentConf);
		} else {
			$this->selectedItem = False;
		}
	}

	public function showArchive() {
		$this->mod->parse('module.terug');
		$this->show("1");
	}
	
	public function show($archive = "0") {
		$search['archive'] = $archive;
		$search['hide'] = "0";

		$items = $this->contentManager->getContentItems($search);
		$list = new Listing();
		$list->setNoSorting();
		$list->setPageSize($this->contentConf['pagesize']);

		if(!$this->selectedItem){
 			if($archive == "0") {
 				$this->mod->parse('module.archive');
			}
			foreach($items as $item) {
				$list->addRecord($item->getTemplateData());
			}
			if($archive == "0"){
				$this->mod->assign("NEWSITEMS",domodule('lister', '', 'newsshow', array('list' => $list)));
			} else {
				$this->mod->assign("NEWSITEMS",domodule('lister', '', 'newsarchiveshow', array('list' => $list)));
			}
			$this->mod->parse('module.newsitems');
			if(count($items) == 1) {
				$news = $items[0]->getTemplateData();
				$this->mod->assign('ITEM', $news);
				$files = $items[0]->getFiles();
				if(count($files)) {
					$thisfile = array_shift($files);
					$this->mod->assign('PHOTOSMALL', mypicture($thisfile['myfile'], 'small'));
					$this->mod->assign('PHOTOMEDIUM', mypicture($thisfile['myfile'], 'medium'));
					$this->mod->assign('PHOTOLARGE', mypicture($thisfile['myfile'], 'large'));
					$this->mod->parse('module.selectedItem.photo');
				}
		#		$this->mod->parse('module.selectedItem');
			}
		} else {
			$this->mod->parse('module.terug');
			$news = $this->selectedItem->getTemplateData();
			if($news['title'] != '') {
				$this->mod->assign('ITEM', $news);
				$this->mod->parse('module.selectedItem');
			}
		}
	}

	public function rss($archive = "0") {
		$search['archive'] = $archive;
		$search['hide'] = "0";

		$items = $this->contentManager->getContentItems($search);
		$list = new Listing();
		$list->setPageSize($this->contentConf['pagesize']);

		foreach($items as $item) {
			$list->addRecord($item->getTemplateData());
		}

		header('Content-type: text/xml');
		global $page;
		$page = new TemplateProxy("templates/empty.inc.html");
		$this->mod = new TemplateProxy(BASEMODULESPATH . "modules/newsshow/templates/rss.inc.html");

		$this->mod->assign("NEWSITEMS",domodule('lister', '', 'newsshowrss', array('list' => $list)));
		echo $this->mod->parseModule('rss');
		exit;
	}


}
?>
