<?php
$userManager = new UserManager();
$user = $userManager->getLoggedInUser();
$settings = $user->getSettingsArrayForCategory($_SESSION['selectedcat']);

if(isset($_POST['send']) && isset($_POST['wonder']) && $_POST['wonder'] == ""){
	$contactConfigPath = BASEPATH."modules/content/configs/contact.inc.php";
	if(!file_exists($contactConfigPath)) {
		$contactConfigPath = BASEMODULESPATH."modules/content/configs/contact.inc.php";
	}
	$contactContent = new Content(false, $contactConfigPath);
	$contactContent->setCategoryId($_SESSION['selectedcat']);
	$contactContent->readFromForm();
	if(!$contactContent->hasValidateError()){
		$mail = new PHPMailer();
		$mail->From     = $settings['from'];
		$mail->FromName = $settings['fromname'];
		$mail->Host     = $settings['mailhost'];
		$mail->Subject  = $settings['subject'];
		$mail->Mailer   = "smtp";

		$body[] = $text['hello']." ". $contactContent->getValue("name") .",\n\n " ;
		$body[] = $settings['messageForClient'];
		foreach($contactContent->getFields() as $field) {
			$fieldname = $field->getFieldName();
			$body[] = $text[$fieldname].": ". $field->getValue();
		}
		if(isset($_POST['orders'])){
			$orders = $_POST['orders'];
			foreach($orders as $key => $value) {
				if($value > 0){
					$body[] = "Product: $key, Aantal: $value";
				}
				if($fieldname == 'email') {
					$visitorEmail = $field->getValue();
				}
			}
		}

		$bodystring = join("\n", $body);

		$mail->Body    = nl2br($bodystring);
		$mail->AltBody = $bodystring;
		$mail->AddAddress($settings['to'], "");
		if(isset($visitorEmail)) {
			$mail->AddBCC($visitorEmail, "");
		}

		if(!$mail->Send()) {
			$_SESSION['messages'][] = "There has been a mail error sending to " . $settings['to'] . "<br>";
		} else {
			$_SESSION['messages'][] = $text['mailsent'];
		}

		$mail->ClearAddresses();
	} else {
		$errorFields = array();
		foreach($contactContent->getErrorFields() as $errorField) {
			$errorFields[] = $text[$errorField];
		}
		$_SESSION['messages'][] = $text['errorfield'].join(',', $errorFields);
		$mod->assign('CONTACT', $contactContent->getTemplateData());
	}
}
$category = new Category($settings['categoryId']);

$configPath = BASEPATH."modules/content/configs/".$category->getTemplate().".inc.php";
if(!file_exists($configPath)) {
	$configPath = BASEMODULESPATH."modules/content/configs/".$category->getTemplate().".inc.php";
}

$contentManager = new ContentManager($settings['categoryId'], $configPath);
$contentItems = $contentManager->getContentItems();

foreach($contentItems as $contentItem) {
	$contentTemplateData = $contentItem->getTemplateData();
	$mod->assign('ITEMS', $contentTemplateData);

	foreach($contentItem->getFiles() as $num => $thisfile) {
		$mod->assign('SMALLPHOTO', mypicture($thisfile['myfile'], 'small'));
		$med = mypicture($thisfile['myfile'], 'medium');
		$mod->assign('MEDIUMPHOTO', $med);
		$mod->parse('module.itemlist.items.photo');
	}
	$mod->parse('module.itemlist.items');
}
$mod->parse('module.itemlist');
?>
