<?php
/*
 * Author			: E J Jonkers    
 * company			: DataCT    
 * date created		: 06-01-24
 * date modified	:     
 */
$userManager = new UserManager();
$loggedInUser = $userManager->getLoggedInUser();

if(isset($_POST['cancel'])) {
	autojump();
}

$userSettingsOnly = false;
if(isset($_GET['groupId'])){
	$object = new Group($_GET['groupId']);
	$userSettingsOnly = true;
} else if(isset($_GET['userId'])){
	$object = new User($_GET['userId']);
	$userSettingsOnly = true;
} else if(isset($_GET['category'])){
	$object = new Category($_GET['category']);
	$userSettingsOnly = false;
} else {
	$object = $loggedInUser;
	$userSettingsOnly = true;
}

//$categoryManager = new CategoryManager();
//$categoryManager->clearCache();
if(isset($object) && $object !== false){
	if(isset($_POST['save'])){
		$settings = $object->getAllSettings();
#		if(isset($_POST['settings']) && is_array($_POST['settings'])){
#			$settings = $_POST['settings'];
#		} else {
#			$settings = array();
#		}
		$hasErrors = array();
		foreach($settings as $settingIdentifier => $setting){
			$value = isset($_POST['settings'][$settingIdentifier]) ? $_POST['settings'][$settingIdentifier] : '';
			$setting = $object->getSetting($settingIdentifier);
			if($userSettingsOnly && !$setting->isUserSetting()){
				$category = new Category($setting->getCategoryId());
				$setting = $category->getSetting($settingIdentifier);
				$setting->setValue($value);
				if($setting->isValid()) {
					$hasErrors[] = $setting->getName();
				} else {
					$category->saveSetting($setting);
				}
			} else {
				$setting->setValue($value);
				if($setting->isValid()) {
					$hasErrors[] = $setting->getName();
				} else {
					$object->saveSetting($setting);
				}
			}
		}
		if(count($hasErrors)) {
			$_SESSION['messages'][] = "De volgende settings zijn niet correct: ".join(', ', $hasErrors);
		} else {
			$_SESSION['messages'][] = "Settings saved";
		}
	}

	$settings = array();
	$settings = $object->getAllSettings();

	$curCategory = false;
	if(count($settings)) {
		foreach($settings as $setting) {
			if(($setting->isUserSetting() == $userSettingsOnly) or ($loggedInUser->hasPermission($setting->getCategoryId(), $setting->getNeededPermission()))){
					if(!$curCategory or $curCategory->getCategoryId() != $setting->getCategoryId()){
						$curCategory = new Category($setting->getCategoryId());
						$mod->assign('CATEGORY', $curCategory->getName());
					} else {
						$mod->assign('CATEGORY', "");
					}
					$data = $setting->getTemplateData();
					$mod->assign('SETTING', $data);
					switch($setting->getType()){
						case "text":
							$mod->parse('module.settings.setting.text');
							break;
						case "checkbox":
							$settingChecked = $data['value'] == 'True' ? 'checked': '';
							$mod->assign('settingChecked', $settingChecked);
							$mod->parse('module.settings.setting.checkbox');
							break;
					}
					$mod->parse('module.settings.setting');
				} else {
				//	echo $setting->getIdentificationString();
				}
		}
		$mod->parse('module.settings');
		$mod->parse('module.savebutton');
	} else {
		$mod->parse('module.nosettings');
	}
} else {
	$mod->parse('module.nosettings');
}
?>
